/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public abstract class StringUnaryUDFDirect
extends VectorExpression {
    private static final long serialVersionUID = 1L;

    public StringUnaryUDFDirect(int inputColumn, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
    }

    public StringUnaryUDFDirect() {
    }

    protected abstract void func(BytesColumnVector var1, byte[][] var2, int[] var3, int[] var4, int var5);

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.inputColumnNum[0]];
        int[] sel = batch.selected;
        int n = batch.size;
        byte[][] vector = inputColVector.vector;
        int[] start = inputColVector.start;
        int[] length = inputColVector.length;
        BytesColumnVector outputColVector = (BytesColumnVector)batch.cols[this.outputColumnNum];
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.initBuffer();
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.func(outputColVector, vector, start, length, 0);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.func(outputColVector, vector, start, length, i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.func(outputColVector, vector, start, length, i);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.func(outputColVector, vector, start, length, i);
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputColVector.isNull[i] = inputColVector.isNull[i];
                    if (inputColVector.isNull[i]) continue;
                    this.func(outputColVector, vector, start, length, i);
                }
            } else {
                System.arraycopy(inputColVector.isNull, 0, outputColVector.isNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputColVector.isNull[i]) continue;
                    this.func(outputColVector, vector, start, length, i);
                }
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

