/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.util.Arrays;
import java.util.Properties;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinAntiJoinGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashSet;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinAntiJoinMultiKeyOperator
extends VectorMapJoinAntiJoinGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorMapJoinAntiJoinMultiKeyOperator.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private transient VectorMapJoinBytesHashSet hashSet;
    private transient VectorSerializeRow keyVectorSerializeWrite;
    private transient ByteStream.Output currentKeyOutput;
    private transient ByteStream.Output saveKeyOutput;

    @Override
    protected String getLoggingPrefix() {
        return super.getLoggingPrefix(CLASS_NAME);
    }

    protected VectorMapJoinAntiJoinMultiKeyOperator() {
    }

    public VectorMapJoinAntiJoinMultiKeyOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinAntiJoinMultiKeyOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        super(ctx, conf, vContext, vectorDesc);
    }

    @Override
    protected void commonSetup() throws HiveException {
        super.commonSetup();
        this.keyVectorSerializeWrite = new VectorSerializeRow<BinarySortableSerializeWrite>(BinarySortableSerializeWrite.with((Properties)((MapJoinDesc)this.getConf()).getKeyTblDesc().getProperties(), (int)this.bigTableKeyColumnMap.length));
        this.keyVectorSerializeWrite.init(this.bigTableKeyTypeInfos, this.bigTableKeyColumnMap);
        this.currentKeyOutput = new ByteStream.Output();
        this.saveKeyOutput = new ByteStream.Output();
    }

    @Override
    public void hashTableSetup() throws HiveException {
        super.hashTableSetup();
        this.hashSet = (VectorMapJoinBytesHashSet)this.vectorMapJoinHashTable;
    }

    @Override
    public void processBatch(VectorizedRowBatch batch) throws HiveException {
        try {
            boolean allKeyInputColumnsRepeating;
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(batch);
            }
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                return;
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            if (this.bigTableKeyColumnMap.length == 0) {
                allKeyInputColumnsRepeating = false;
            } else {
                allKeyInputColumnsRepeating = true;
                for (int i = 0; i < this.bigTableKeyColumnMap.length; ++i) {
                    if (batch.cols[this.bigTableKeyColumnMap[i]].isRepeating) continue;
                    allKeyInputColumnsRepeating = false;
                    break;
                }
            }
            if (allKeyInputColumnsRepeating) {
                JoinUtil.JoinResult joinResult;
                this.keyVectorSerializeWrite.setOutput(this.currentKeyOutput);
                this.keyVectorSerializeWrite.serializeWrite(batch, 0);
                if (this.keyVectorSerializeWrite.getHasAnyNulls()) {
                    joinResult = JoinUtil.JoinResult.MATCH;
                } else {
                    byte[] keyBytes = this.currentKeyOutput.getData();
                    int keyLength = this.currentKeyOutput.getLength();
                    joinResult = this.hashSet.contains(keyBytes, 0, keyLength, this.hashSetResults[0]);
                    joinResult = this.inverseResultForAntiJoin(joinResult);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name());
                }
                this.finishAntiRepeated(batch, joinResult, this.hashSetResults[0]);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated");
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashSetResultCount = 0;
                int allMatchCount = 0;
                int spillCount = 0;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block21: for (int logical = 0; logical < inputLogicalSize; ++logical) {
                    int batchIndex = selectedInUse ? selected[logical] : logical;
                    this.keyVectorSerializeWrite.setOutput(this.currentKeyOutput);
                    this.keyVectorSerializeWrite.serializeWrite(batch, batchIndex);
                    boolean isAnyNull = this.keyVectorSerializeWrite.getHasAnyNulls();
                    if (isAnyNull || !haveSaveKey || !this.saveKeyOutput.arraysEquals(this.currentKeyOutput)) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: {
                                    break;
                                }
                                case SPILL: {
                                    ++hashSetResultCount;
                                    break;
                                }
                            }
                        }
                        if (isAnyNull) {
                            saveJoinResult = JoinUtil.JoinResult.MATCH;
                            haveSaveKey = false;
                        } else {
                            haveSaveKey = true;
                            ByteStream.Output temp = this.saveKeyOutput;
                            this.saveKeyOutput = this.currentKeyOutput;
                            this.currentKeyOutput = temp;
                            byte[] keyBytes = this.saveKeyOutput.getData();
                            int keyLength = this.saveKeyOutput.getLength();
                            saveJoinResult = this.hashSet.contains(keyBytes, 0, keyLength, this.hashSetResults[hashSetResultCount]);
                            saveJoinResult = this.inverseResultForAntiJoin(saveJoinResult);
                        }
                        switch (saveJoinResult) {
                            case MATCH: {
                                this.allMatches[allMatchCount++] = batchIndex;
                                break;
                            }
                            case SPILL: {
                                this.spills[spillCount] = batchIndex;
                                this.spillHashMapResultIndices[spillCount] = hashSetResultCount;
                                ++spillCount;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            this.allMatches[allMatchCount++] = batchIndex;
                            continue block21;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashSetResultCount;
                            ++spillCount;
                            continue block21;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: {
                            break;
                        }
                        case SPILL: {
                            ++hashSetResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " allMatches " + VectorMapJoinAntiJoinMultiKeyOperator.intArrayToRangesString(this.allMatches, allMatchCount) + " spills " + VectorMapJoinAntiJoinMultiKeyOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinAntiJoinMultiKeyOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashSetResults, 0, hashSetResultCount)));
                }
                this.finishAnti(batch, allMatchCount, spillCount, this.hashSetResults);
            }
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }
}

