/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;

public class OperatorHealthCheckerHook
implements ExecuteWithHookContext {
    public static void checkOperator(Operator<?> op) {
        Object conf = op.getConf();
        Map<String, ExprNodeDesc> exprMap = conf.getColumnExprMap();
        RowSchema schema = op.getSchema();
        OperatorHealthCheckerHook.checkSchema(schema);
        if (op instanceof SelectOperator) {
            OperatorHealthCheckerHook.checkSelectOperator((SelectOperator)op);
        }
        if (schema != null && exprMap != null) {
            for (Map.Entry<String, ExprNodeDesc> c : exprMap.entrySet()) {
                if (c.getValue() instanceof ExprNodeConstantDesc) continue;
                ColumnInfo ci = schema.getColumnInfo(c.getKey());
                if (c.getKey().startsWith(Utilities.ReduceField.KEY + ".reducesinkkey") || ci == null && conf.getComputedFields().contains(c.getKey()) || ci != null) continue;
                throw new RuntimeException("schema not found for " + c + " in " + schema);
            }
            for (ColumnInfo sig : schema.getSignature()) {
                if (op instanceof ScriptOperator) continue;
                String iName = sig.getInternalName();
                ExprNodeDesc e = exprMap.get(iName);
                if (OperatorHealthCheckerHook.isSemiJoinRS(op) || op.getConf() instanceof GroupByDesc || e != null) continue;
                throw new RuntimeException("expr not found for " + iName + " in " + exprMap);
            }
        }
    }

    private static void checkSchema(RowSchema schema) {
        if (schema != null) {
            List<String> cn = schema.getColumnNames();
            HashSet<String> cn2 = new HashSet<String>(cn);
            if (cn.size() != cn2.size()) {
                throw new RuntimeException("ambiguous columns in the schema!");
            }
        }
    }

    private static void checkSelectOperator(SelectOperator op) {
        HashSet<String> ocn;
        SelectDesc conf = (SelectDesc)op.getConf();
        RowSchema schema = op.getSchema();
        if (schema == null) {
            throw new RuntimeException("I expect a schema for all SelectOp" + op);
        }
        HashSet<String> cn = new HashSet<String>(schema.getColumnNames());
        Sets.SetView diff = Sets.symmetricDifference(cn, ocn = new HashSet<String>(conf.getOutputColumnNames()));
        if (!diff.isEmpty()) {
            throw new RuntimeException("SelOp output/schema mismatch ");
        }
    }

    private static boolean isSemiJoinRS(Operator<?> op) {
        if (op instanceof ReduceSinkOperator) {
            List<Operator<OperatorDesc>> children = op.getChildOperators();
            for (Operator<OperatorDesc> c : children) {
                if (c instanceof TableScanOperator) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void runCheck(ParseContext pctx) throws SemanticException {
        if (OperatorHealthCheckerHook.class.desiredAssertionStatus()) {
            OperatorHealthCheckerHook h = new OperatorHealthCheckerHook();
            HashSet<Node> rootOps = new HashSet<Node>();
            rootOps.addAll(pctx.getTopOps().values());
            h.walkTree(rootOps);
        }
    }

    @Override
    public void run(HookContext hookContext) throws Exception {
        ArrayList rootOps = Lists.newArrayList();
        List<Task<?>> roots = hookContext.getQueryPlan().getRootTasks();
        for (Task<?> task : roots) {
            Object work = task.getWork();
            if (work instanceof MapredWork) {
                ReduceWork reduceWork;
                MapredWork mapredWork = (MapredWork)work;
                MapWork mapWork = mapredWork.getMapWork();
                if (mapWork != null) {
                    rootOps.addAll(mapWork.getAllRootOperators());
                }
                if ((reduceWork = mapredWork.getReduceWork()) != null) {
                    rootOps.addAll(reduceWork.getAllRootOperators());
                }
            }
            if (!(work instanceof TezWork)) continue;
            for (BaseWork bw : ((TezWork)work).getAllWorkUnsorted()) {
                rootOps.addAll(bw.getAllRootOperators());
            }
        }
        this.walkTree(rootOps);
    }

    private void walkTree(Collection<Node> rootOps) throws SemanticException {
        if (rootOps.isEmpty()) {
            return;
        }
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(new OperatorHealthCheckerProcessor(), new HashMap<SemanticRule, SemanticNodeProcessor>(), null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
        ogw.startWalking(rootOps, nodeOutput);
    }

    static class OperatorHealthCheckerProcessor
    implements SemanticNodeProcessor {
        Map<String, Operator<?>> opMap = new HashMap();

        OperatorHealthCheckerProcessor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            OperatorHealthCheckerHook.checkOperator(op);
            String opKey = op.getOperatorId();
            if (this.opMap.containsKey(opKey)) {
                throw new RuntimeException("operator id reuse found: " + opKey);
            }
            this.opMap.put(opKey, op);
            return null;
        }
    }
}

