/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.parquet.ProjectionPusher;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.hadoop.hive.ql.io.parquet.read.ParquetFilterPredicateConverter;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.compat.RowGroupFilter;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParquetRecordReaderBase {
    public static final Logger LOG = LoggerFactory.getLogger(ParquetRecordReaderBase.class);
    protected final FileSplit fileSplit;
    protected Path filePath;
    protected ParquetInputSplit parquetInputSplit;
    protected ParquetMetadata parquetMetadata;
    protected ProjectionPusher projectionPusher;
    protected boolean skipTimestampConversion = false;
    protected Boolean skipProlepticConversion;
    protected Boolean legacyConversionEnabled;
    protected SerDeStats serDeStats = new SerDeStats();
    protected final JobConf jobConf;
    protected int schemaSize;
    protected List<BlockMetaData> filteredBlocks;
    protected ParquetFileReader reader;

    protected ParquetRecordReaderBase(JobConf conf, InputSplit oldSplit) throws IOException {
        this.projectionPusher = new ProjectionPusher();
        if (!(oldSplit instanceof FileSplit)) {
            throw new IllegalArgumentException("Unknown split type: " + oldSplit);
        }
        this.fileSplit = (FileSplit)oldSplit;
        this.jobConf = this.projectionPusher.pushProjectionsAndFilters(conf, this.fileSplit.getPath().getParent());
        this.filePath = this.fileSplit.getPath();
    }

    protected void setupMetadataAndParquetSplit(JobConf conf, ParquetMetadata metadata) throws IOException {
        if (this.fileSplit.getLength() != 0L) {
            this.parquetMetadata = metadata != null ? metadata : this.getParquetMetadata(this.filePath, conf);
            this.parquetInputSplit = this.getSplit(conf);
        }
    }

    protected ParquetInputSplit getSplit(JobConf conf) throws IOException {
        Path finalPath = this.fileSplit.getPath();
        List blocks = this.parquetMetadata.getBlocks();
        FileMetaData fileMetaData = this.parquetMetadata.getFileMetaData();
        ReadSupport.ReadContext readContext = new DataWritableReadSupport().init(new InitContext((Configuration)this.jobConf, null, fileMetaData.getSchema()));
        for (BlockMetaData bmd : blocks) {
            this.serDeStats.setRowCount(this.serDeStats.getRowCount() + bmd.getRowCount());
            this.serDeStats.setRawDataSize(this.serDeStats.getRawDataSize() + bmd.getTotalByteSize());
        }
        this.schemaSize = MessageTypeParser.parseMessageType((String)((String)readContext.getReadSupportMetadata().get("HIVE_TABLE_SCHEMA"))).getFieldCount();
        ArrayList<BlockMetaData> splitGroup = new ArrayList<BlockMetaData>();
        long splitStart = this.fileSplit.getStart();
        long splitLength = this.fileSplit.getLength();
        for (BlockMetaData block : blocks) {
            long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(0)).getFirstDataPageOffset();
            if (firstDataPage < splitStart || firstDataPage >= splitStart + splitLength) continue;
            splitGroup.add(block);
        }
        if (splitGroup.isEmpty()) {
            LOG.warn("Skipping split, could not find row group in: " + this.fileSplit);
            return null;
        }
        FilterCompat.Filter filter = this.setFilter(this.jobConf, fileMetaData.getSchema());
        if (filter != null) {
            this.filteredBlocks = RowGroupFilter.filterRowGroups((FilterCompat.Filter)filter, splitGroup, (MessageType)fileMetaData.getSchema());
            if (this.filteredBlocks.isEmpty()) {
                LOG.debug("All row groups are dropped due to filter predicates");
                return null;
            }
            long droppedBlocks = splitGroup.size() - this.filteredBlocks.size();
            if (droppedBlocks > 0L) {
                LOG.debug("Dropping " + droppedBlocks + " row groups that do not pass filter predicate");
            }
        } else {
            this.filteredBlocks = splitGroup;
        }
        if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION)) {
            this.skipTimestampConversion = !Strings.nullToEmpty((String)fileMetaData.getCreatedBy()).startsWith("parquet-mr");
        }
        this.skipProlepticConversion = DataWritableReadSupport.getWriterDateProleptic(fileMetaData.getKeyValueMetaData());
        if (this.skipProlepticConversion == null) {
            this.skipProlepticConversion = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PARQUET_DATE_PROLEPTIC_GREGORIAN_DEFAULT);
        }
        this.legacyConversionEnabled = DataWritableReadSupport.getZoneConversionLegacy(fileMetaData.getKeyValueMetaData(), (Configuration)conf);
        ParquetInputSplit split = new ParquetInputSplit(finalPath, splitStart, splitLength, this.fileSplit.getLocations(), this.filteredBlocks, readContext.getRequestedSchema().toString(), fileMetaData.getSchema().toString(), fileMetaData.getKeyValueMetaData(), readContext.getReadSupportMetadata());
        return split;
    }

    protected ParquetMetadata getParquetMetadata(Path path, JobConf conf) throws IOException {
        return ParquetFileReader.readFooter((Configuration)this.jobConf, (Path)path);
    }

    public FilterCompat.Filter setFilter(JobConf conf, MessageType schema) {
        SearchArgument sarg = ConvertAstToSearchArg.createFromConf((Configuration)conf);
        if (sarg == null) {
            return null;
        }
        String columnTypes = conf.get("columns.types");
        String columnNames = conf.get("columns");
        ArrayList columnTypeList = TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypes);
        HashMap<String, TypeInfo> columns = new HashMap<String, TypeInfo>();
        String[] names = columnNames.split(",");
        for (int i = 0; i < names.length; ++i) {
            columns.put(names[i], (TypeInfo)columnTypeList.get(i));
        }
        MessageType newSchema = this.getSchemaWithoutPartitionColumns(conf, schema);
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate(sarg, newSchema, columns);
        if (p != null) {
            LOG.debug("PARQUET predicate push down generated.");
            ParquetInputFormat.setFilterPredicate((Configuration)conf, (FilterPredicate)p);
            return FilterCompat.get((FilterPredicate)p);
        }
        LOG.debug("No PARQUET predicate push down is generated.");
        return null;
    }

    private MessageType getSchemaWithoutPartitionColumns(JobConf conf, MessageType schema) {
        List<String> partCols = Utilities.getPartitionColumnNames((Configuration)conf);
        if (partCols.isEmpty()) {
            return schema;
        }
        ArrayList<Type> newFields = new ArrayList<Type>();
        for (Type field : schema.getFields()) {
            if (partCols.contains(field.getName())) continue;
            newFields.add(field);
        }
        return new MessageType(schema.getName(), newFields);
    }

    public List<BlockMetaData> getFilteredBlocks() {
        return this.filteredBlocks;
    }

    public SerDeStats getStats() {
        return this.serDeStats;
    }
}

