/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.AbortTxnMessage;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;

class AbortTxnHandler
extends AbstractEventHandler<AbortTxnMessage> {
    AbortTxnHandler(NotificationEvent event) {
        super(event);
    }

    @Override
    AbortTxnMessage eventMessage(String stringRepresentation) {
        return this.deserializer.getAbortTxnMessage(stringRepresentation);
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        if (!ReplUtils.includeAcidTableInDump(withinContext.hiveConf)) {
            return;
        }
        if (ReplUtils.filterTransactionOperations(withinContext.hiveConf)) {
            String contextDbName = StringUtils.normalizeIdentifier((String)withinContext.replScope.getDbName());
            List writeIds = ((AbortTxnMessage)this.eventMessage).getWriteIds();
            List dbsUpdated = ((AbortTxnMessage)this.eventMessage).getDbsUpdated().stream().map(StringUtils::normalizeIdentifier).collect(Collectors.toList());
            if (writeIds == null || writeIds.isEmpty() || !dbsUpdated.contains(contextDbName)) {
                LOG.info("Filter out #{} ABORT_TXN message : {}", (Object)this.fromEventId(), (Object)this.eventMessageAsJSON);
                return;
            }
        }
        LOG.info("Processing#{} ABORT_TXN message : {}", (Object)this.fromEventId(), (Object)this.eventMessageAsJSON);
        DumpMetaData dmd = withinContext.createDmd(this);
        dmd.setPayload(this.eventMessageAsJSON);
        dmd.write();
    }

    @Override
    public DumpType dumpType() {
        return DumpType.EVENT_ABORT_TXN;
    }
}

