/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.reexec;

import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.reexec.IReExecutionPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReExecutionDagSubmitPlugin
implements IReExecutionPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ReExecutionDagSubmitPlugin.class);
    private boolean retryPossible;

    @Override
    public void initialize(Driver driver) {
        driver.getHookRunner().addOnFailureHook(new LocalHook());
    }

    @Override
    public boolean shouldReExecuteAfterCompile(int executionNum, PlanMapper pm1, PlanMapper pm2) {
        return this.retryPossible;
    }

    @Override
    public boolean shouldReExecute(int executionNum) {
        return this.retryPossible;
    }

    class LocalHook
    implements ExecuteWithHookContext {
        LocalHook() {
        }

        @Override
        public void run(HookContext hookContext) throws Exception {
            Throwable exception;
            if (hookContext.getHookType() == HookContext.HookType.ON_FAILURE_HOOK && (exception = hookContext.getException()) != null && exception.getMessage() != null) {
                if (exception.getMessage().contains("Dag submit failed")) {
                    ReExecutionDagSubmitPlugin.this.retryPossible = true;
                }
                LOG.info("Got exception message: {} retryPossible: {}", (Object)exception.getMessage(), (Object)ReExecutionDagSubmitPlugin.this.retryPossible);
            }
        }
    }
}

