/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.reexec;

import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.reexec.IReExecutionPlugin;

public class ReExecutionOverlayPlugin
implements IReExecutionPlugin {
    private Driver driver;
    private Map<String, String> subtree;
    private boolean retryPossible;

    @Override
    public void initialize(Driver driver) {
        this.driver = driver;
        driver.getHookRunner().addOnFailureHook(new LocalHook());
        HiveConf conf = driver.getConf();
        String queueName = conf.get("tez.queue.name");
        if (queueName != null) {
            conf.set("reexec.overlay.tez.queue.name", queueName);
        }
        this.subtree = conf.subtree("reexec.overlay");
    }

    @Override
    public void prepareToReExecute() {
        HiveConf conf = this.driver.getConf();
        conf.verifyAndSetAll(this.subtree);
    }

    @Override
    public boolean shouldReExecute(int executionNum) {
        return executionNum == 1 && !this.subtree.isEmpty() && this.retryPossible;
    }

    @Override
    public boolean shouldReExecuteAfterCompile(int executionNum, PlanMapper pm1, PlanMapper pm2) {
        return executionNum == 1;
    }

    class LocalHook
    implements ExecuteWithHookContext {
        LocalHook() {
        }

        @Override
        public void run(HookContext hookContext) throws Exception {
            Throwable exception;
            if (hookContext.getHookType() == HookContext.HookType.ON_FAILURE_HOOK && (exception = hookContext.getException()) != null && exception.getMessage() != null && exception.getMessage().contains("Vertex failed,")) {
                ReExecutionOverlayPlugin.this.retryPossible = true;
            }
        }
    }
}

