/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

public class ProcessListInfo {
    private final String sessionId;
    private final String userName;
    private final String ipAddr;
    private final long sessionActiveTime;
    private final long sessionIdleTime;
    private final String executionEngine;
    private final String queryId;
    private final String beginTime;
    private final String runtime;
    private final long elapsedTime;
    private final String state;

    private ProcessListInfo(String userName, String ipAddr, String sessionId, long sessionActiveTime, long sessionIdleTime, String queryId, String executionEngine, String beginTime, String runtime, long elapsedTime, String state) {
        this.userName = userName;
        this.ipAddr = ipAddr;
        this.sessionId = sessionId;
        this.sessionActiveTime = sessionActiveTime;
        this.sessionIdleTime = sessionIdleTime;
        this.queryId = queryId;
        this.executionEngine = executionEngine;
        this.beginTime = beginTime;
        this.runtime = runtime;
        this.elapsedTime = elapsedTime;
        this.state = state;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getIpAddr() {
        return this.ipAddr;
    }

    public long getSessionActiveTime() {
        return this.sessionActiveTime;
    }

    public long getSessionIdleTime() {
        return this.sessionIdleTime;
    }

    public String getExecutionEngine() {
        return this.executionEngine;
    }

    public String getBeginTime() {
        return this.beginTime;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String getState() {
        return this.state;
    }

    public static class Builder {
        private String userName;
        private String ipAddr;
        private String sessionId;
        private long sessionActiveTime;
        private long sessionIdleTime;
        private String executionEngine;
        private String beginTime;
        private String queryId;
        private String runtime;
        private long elapsedTime;
        private String state;

        public Builder setSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder setIpAddr(String ipAddr) {
            this.ipAddr = ipAddr;
            return this;
        }

        public Builder setSessionActiveTime(long sessionActiveTime) {
            this.sessionActiveTime = sessionActiveTime;
            return this;
        }

        public Builder setSessionIdleTime(long sessionIdleTime) {
            this.sessionIdleTime = sessionIdleTime;
            return this;
        }

        public Builder setExecutionEngine(String executionEngine) {
            this.executionEngine = executionEngine;
            return this;
        }

        public Builder setBeginTime(String beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        public Builder setQueryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public Builder setRuntime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        public Builder setElapsedTime(long elapsedTime) {
            this.elapsedTime = elapsedTime;
            return this;
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public ProcessListInfo build() {
            ProcessListInfo processListInfo = new ProcessListInfo(this.userName, this.ipAddr, this.sessionId, this.sessionActiveTime, this.sessionIdleTime, this.queryId, this.executionEngine, this.beginTime, this.runtime, this.elapsedTime, this.state);
            return processListInfo;
        }
    }
}

