/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.exec.DDLPlanUtils;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hive.common.util.HiveStringUtils;

abstract class CompactionQueryBuilder {
    protected Operation operation;
    protected String resultTableName;
    protected Table sourceTab;
    protected String location;
    protected ValidWriteIdList validWriteIdList;
    protected AcidDirectory dir;
    protected Partition sourcePartition;
    protected String sourceTabForInsert;
    protected String orderByClause;
    protected StorageDescriptor storageDescriptor;
    protected int numberOfBuckets;
    protected boolean isPartitioned;
    protected boolean isBucketed;
    protected boolean isDeleteDelta;
    protected boolean insertOnly;
    protected CompactionType compactionType;

    CompactionQueryBuilder setSourceTab(Table sourceTab) {
        this.sourceTab = sourceTab;
        return this;
    }

    CompactionQueryBuilder setLocation(String location) {
        this.location = location;
        return this;
    }

    CompactionQueryBuilder setValidWriteIdList(ValidWriteIdList validWriteIdList) {
        this.validWriteIdList = validWriteIdList;
        return this;
    }

    CompactionQueryBuilder setDir(AcidDirectory dir) {
        this.dir = dir;
        return this;
    }

    CompactionQueryBuilder setSourcePartition(Partition sourcePartition) {
        this.sourcePartition = sourcePartition;
        return this;
    }

    CompactionQueryBuilder setSourceTabForInsert(String sourceTabForInsert) {
        this.sourceTabForInsert = sourceTabForInsert;
        return this;
    }

    public CompactionQueryBuilder setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
        return this;
    }

    CompactionQueryBuilder setPartitioned(boolean partitioned) {
        this.isPartitioned = partitioned;
        return this;
    }

    CompactionQueryBuilder setBucketed(boolean bucketed) {
        if (CompactionType.REBALANCE.equals((Object)this.compactionType) && bucketed) {
            throw new IllegalArgumentException("Rebalance compaction is supported only on implicitly-bucketed tables!");
        }
        this.isBucketed = bucketed;
        return this;
    }

    CompactionQueryBuilder setIsDeleteDelta(boolean deleteDelta) {
        this.isDeleteDelta = deleteDelta;
        return this;
    }

    CompactionQueryBuilder setStorageDescriptor(StorageDescriptor storageDescriptor) {
        this.storageDescriptor = storageDescriptor;
        return this;
    }

    CompactionQueryBuilder setNumberOfBuckets(int numberOfBuckets) {
        this.numberOfBuckets = numberOfBuckets;
        return this;
    }

    CompactionQueryBuilder setOperation(Operation operation) {
        this.operation = operation;
        return this;
    }

    CompactionQueryBuilder setResultTableName(String resultTableName) {
        this.resultTableName = resultTableName;
        return this;
    }

    CompactionQueryBuilder(CompactionType compactionType, boolean insertOnly) {
        if (compactionType == null) {
            throw new IllegalArgumentException("CompactionQueryBuilder.CompactionType cannot be null");
        }
        this.compactionType = compactionType;
        this.insertOnly = insertOnly;
    }

    String build() {
        StringBuilder query = new StringBuilder(this.operation.toString());
        if (this.operation == Operation.CREATE) {
            query.append(" temporary external");
        }
        if (this.operation == Operation.INSERT) {
            query.append(CompactionType.REBALANCE.equals((Object)this.compactionType) ? " overwrite" : " into");
        }
        query.append(" table ");
        if (this.operation == Operation.DROP) {
            query.append("if exists ");
        }
        query.append(this.resultTableName);
        switch (this.operation) {
            case CREATE: {
                this.getDdlForCreate(query);
                break;
            }
            case ALTER: {
                this.buildAddClauseForAlter(query);
                break;
            }
            case INSERT: {
                query.append(" select ");
                this.buildSelectClauseForInsert(query);
                query.append(" from ");
                this.getSourceForInsert(query);
                this.buildWhereClauseForInsert(query);
                break;
            }
        }
        return query.toString();
    }

    protected void getDdlForCreate(StringBuilder query) {
        this.defineColumns(query);
        if (this.isPartitioned) {
            query.append(" PARTITIONED BY (`file_name` STRING) ");
        }
        query.append(" stored as orc");
        if (this.location != null) {
            query.append(" LOCATION '").append(HiveStringUtils.escapeHiveCommand((String)this.location)).append("'");
        }
        this.addTblProperties(query, false, 0);
    }

    protected void addTblProperties(StringBuilder query, boolean addBucketingVersion, int bucketingVersion) {
        HashMap<String, String> tblProperties = new HashMap<String, String>();
        tblProperties.put("transactional", "false");
        tblProperties.put("compactiontable", this.compactionType.name());
        if (addBucketingVersion) {
            tblProperties.put("bucketing_version", String.valueOf(bucketingVersion));
        }
        if (this.sourceTab != null) {
            this.sourceTab.getParameters().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("orc.")).forEach(e -> tblProperties.put((String)e.getKey(), HiveStringUtils.escapeHiveCommand((String)((String)e.getValue()))));
        }
        this.addTblProperties(query, tblProperties);
    }

    protected void addTblProperties(StringBuilder query, Map<String, String> tblProperties) {
        if (tblProperties != null && !tblProperties.isEmpty()) {
            query.append(" TBLPROPERTIES (");
            boolean isFirst = true;
            for (Map.Entry<String, String> property : tblProperties.entrySet()) {
                if (!isFirst) {
                    query.append(", ");
                }
                query.append("'").append(property.getKey()).append("'='").append(property.getValue()).append("'");
                isFirst = false;
            }
            query.append(")");
        }
    }

    private void buildAddClauseForAlter(StringBuilder query) {
        if (this.validWriteIdList == null || this.dir == null) {
            query.setLength(0);
            return;
        }
        long minWriteID = this.validWriteIdList.getMinOpenWriteId() == null ? 1L : this.validWriteIdList.getMinOpenWriteId();
        long highWatermark = this.validWriteIdList.getHighWatermark();
        List<AcidUtils.ParsedDelta> deltas = this.dir.getCurrentDirectories().stream().filter(delta -> delta.isDeleteDelta() == this.isDeleteDelta && delta.getMaxWriteId() <= highWatermark && delta.getMinWriteId() >= minWriteID).collect(Collectors.toList());
        if (deltas.isEmpty()) {
            query.setLength(0);
            return;
        }
        query.append(" add ");
        deltas.forEach(delta -> query.append("partition (file_name='").append(delta.getPath().getName()).append("') location '").append(delta.getPath()).append("' "));
    }

    protected abstract void buildSelectClauseForInsert(StringBuilder var1);

    protected void getSourceForInsert(StringBuilder query) {
        if (this.sourceTabForInsert != null) {
            query.append(this.sourceTabForInsert);
        } else {
            query.append(this.sourceTab.getDbName()).append(".").append(this.sourceTab.getTableName());
        }
        query.append(" ");
    }

    protected void buildWhereClauseForInsert(StringBuilder query) {
        if (this.sourcePartition != null && this.sourceTab != null) {
            List vals = this.sourcePartition.getValues();
            List keys = this.sourceTab.getPartitionKeys();
            if (keys.size() != vals.size()) {
                throw new IllegalStateException("source partition values (" + Arrays.toString(vals.toArray()) + ") do not match source table values (" + Arrays.toString(keys.toArray()) + "). Failing compaction.");
            }
            query.append(" where ");
            for (int i = 0; i < keys.size(); ++i) {
                FieldSchema keySchema = (FieldSchema)keys.get(i);
                query.append(i == 0 ? "`" : " and `").append(keySchema.getName()).append("`=");
                if (!keySchema.getType().equalsIgnoreCase("boolean")) {
                    query.append("'").append((String)vals.get(i)).append("'");
                    continue;
                }
                query.append((String)vals.get(i));
            }
        }
    }

    protected void appendColumns(StringBuilder query, List<FieldSchema> cols, boolean alias) {
        if (cols == null) {
            throw new IllegalStateException("Query could not be created: Source columns are unknown");
        }
        for (int i = 0; i < cols.size(); ++i) {
            if (alias) {
                query.append(i == 0 ? "'" : ", '").append(cols.get(i).getName()).append("', `").append(cols.get(i).getName()).append("`");
                continue;
            }
            query.append(i == 0 ? "`" : ", `").append(cols.get(i).getName()).append("`");
        }
    }

    protected void defineColumns(StringBuilder query) {
        if (this.sourceTab != null) {
            query.append("(").append("`operation` int, `originalTransaction` bigint, `bucket` int, `rowId` bigint, `currentTransaction` bigint, ").append("`row` struct<").append(StringUtils.join(this.getColumnDescs(), (char)',')).append(">) ");
        }
    }

    protected List<String> getColumnDescs() {
        List cols = this.sourceTab.getSd().getCols();
        ArrayList<String> columnDescs = new ArrayList<String>();
        for (FieldSchema col : cols) {
            String columnType = DDLPlanUtils.formatType(TypeInfoUtils.getTypeInfoFromTypeString((String)col.getType()));
            String columnDesc = "`" + col.getName() + "` " + (!this.insertOnly ? ":" : "") + columnType;
            columnDescs.add(columnDesc);
        }
        return columnDescs;
    }

    static enum Operation {
        CREATE,
        ALTER,
        INSERT,
        DROP;

    }
}

