/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncExpDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncExpLongToDouble;
import org.apache.hadoop.hive.ql.udf.UDFMath;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="exp", value="_FUNC_(x) - Returns e to the power of x", extended="Example:\n   > SELECT _FUNC_(0) FROM src LIMIT 1;\n  1")
@VectorizedExpressions(value={FuncExpDoubleToDouble.class, FuncExpLongToDouble.class})
public class UDFExp
extends UDFMath {
    private final DoubleWritable result = new DoubleWritable();

    @Override
    protected DoubleWritable doEvaluate(DoubleWritable a) {
        this.result.set(StrictMath.exp(a.get()));
        return this.result;
    }
}

