/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressionsSupportDecimal64;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.stats.estimator.PessimisticStatCombiner;
import org.apache.hadoop.hive.ql.stats.estimator.StatEstimator;
import org.apache.hadoop.hive.ql.stats.estimator.StatEstimatorProvider;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="coalesce", value="_FUNC_(a1, a2, ...) - Returns the first non-null argument", extended="Example:\n  > SELECT _FUNC_(NULL, 1, NULL) FROM src LIMIT 1;\n  1")
@VectorizedExpressionsSupportDecimal64
public class GenericUDFCoalesce
extends GenericUDF
implements StatEstimatorProvider {
    private transient ObjectInspector[] argumentOIs;
    private transient GenericUDFUtils.ReturnObjectInspectorResolver returnOIResolver;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentTypeException {
        this.argumentOIs = arguments;
        this.returnOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        for (int i = 0; i < arguments.length; ++i) {
            if (this.returnOIResolver.update(arguments[i])) continue;
            throw new UDFArgumentTypeException(i, "The expressions after COALESCE should all have the same type: \"" + this.returnOIResolver.get().getTypeName() + "\" is expected but \"" + arguments[i].getTypeName() + "\" is found");
        }
        return this.returnOIResolver.get();
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        for (int i = 0; i < arguments.length; ++i) {
            Object ai = arguments[i].get();
            if (ai == null) continue;
            return this.returnOIResolver.convertIfNecessary(ai, this.argumentOIs[i]);
        }
        return null;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("COALESCE", children, ",");
    }

    @Override
    public StatEstimator getStatEstimator() {
        return new CoalesceStatEstimator();
    }

    static class CoalesceStatEstimator
    implements StatEstimator {
        CoalesceStatEstimator() {
        }

        @Override
        public Optional<ColStatistics> estimate(List<ColStatistics> argStats) {
            PessimisticStatCombiner combiner = new PessimisticStatCombiner();
            for (int i = 0; i < argStats.size(); ++i) {
                combiner.add(argStats.get(i));
            }
            return combiner.getResult();
        }
    }
}

