/*
 * Decompiled with CFR 0.152.
 */
package jodd.net;

public class HtmlEncoder {
    private static final int LEN = 161;
    private static final int LEN_XML = 64;
    private static final char[][] TEXT;
    private static final char[][] ATTR_SQ;
    private static final char[][] ATTR_DQ;
    private static final char[][] TEXT_XML;
    private static final char[] AMP;
    private static final char[] QUOT;
    private static final char[] APOS;
    private static final char[] LT;
    private static final char[] GT;
    private static final char[] NBSP;

    public static String attributeDoubleQuoted(CharSequence value) {
        return HtmlEncoder.encode(value, ATTR_DQ, 161);
    }

    public static String attributeSingleQuoted(CharSequence value) {
        return HtmlEncoder.encode(value, ATTR_SQ, 161);
    }

    public static String text(CharSequence text) {
        return HtmlEncoder.encode(text, TEXT, 161);
    }

    public static String xml(CharSequence text) {
        return HtmlEncoder.encode(text, TEXT_XML, 64);
    }

    private static String encode(CharSequence text, char[][] buff, int bufflen) {
        int len;
        if (text == null || (len = text.length()) == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(len + (len >> 2));
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c < bufflen) {
                buffer.append(buff[c]);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    static {
        int i;
        TEXT = new char[161][];
        ATTR_SQ = new char[161][];
        ATTR_DQ = new char[161][];
        TEXT_XML = new char[64][];
        AMP = "&amp;".toCharArray();
        QUOT = "&quot;".toCharArray();
        APOS = "&#39;".toCharArray();
        LT = "&lt;".toCharArray();
        GT = "&gt;".toCharArray();
        NBSP = "&nbsp;".toCharArray();
        for (i = 0; i < 64; ++i) {
            HtmlEncoder.ATTR_DQ[i] = new char[]{(char)i};
            HtmlEncoder.ATTR_SQ[i] = HtmlEncoder.ATTR_DQ[i];
            HtmlEncoder.TEXT[i] = HtmlEncoder.ATTR_DQ[i];
            HtmlEncoder.TEXT_XML[i] = HtmlEncoder.ATTR_DQ[i];
        }
        for (i = 64; i < 161; ++i) {
            HtmlEncoder.ATTR_DQ[i] = new char[]{(char)i};
            HtmlEncoder.ATTR_SQ[i] = HtmlEncoder.ATTR_DQ[i];
            HtmlEncoder.TEXT[i] = HtmlEncoder.ATTR_DQ[i];
        }
        HtmlEncoder.TEXT[38] = AMP;
        HtmlEncoder.TEXT[60] = LT;
        HtmlEncoder.TEXT[62] = GT;
        HtmlEncoder.TEXT[160] = NBSP;
        HtmlEncoder.ATTR_SQ[38] = AMP;
        HtmlEncoder.ATTR_SQ[39] = APOS;
        HtmlEncoder.ATTR_SQ[160] = NBSP;
        HtmlEncoder.ATTR_DQ[38] = AMP;
        HtmlEncoder.ATTR_DQ[34] = QUOT;
        HtmlEncoder.ATTR_DQ[160] = NBSP;
        HtmlEncoder.TEXT_XML[38] = AMP;
        HtmlEncoder.TEXT_XML[34] = QUOT;
        HtmlEncoder.TEXT_XML[39] = APOS;
        HtmlEncoder.TEXT_XML[60] = LT;
        HtmlEncoder.TEXT_XML[62] = GT;
    }
}

