/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import io.opentelemetry.exporter.otlp.internal.OtlpConfigUtil;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporterBuilder;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.AutoConfigureListener;
import io.opentelemetry.sdk.autoconfigure.spi.logs.ConfigurableLogRecordExporterProvider;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.util.concurrent.atomic.AtomicReference;

public class OtlpLogRecordExporterProvider
implements ConfigurableLogRecordExporterProvider,
AutoConfigureListener {
    private final AtomicReference<MeterProvider> meterProviderRef = new AtomicReference<MeterProvider>(MeterProvider.noop());

    public LogRecordExporter createExporter(ConfigProperties config) {
        String protocol = OtlpConfigUtil.getOtlpProtocol("logs", config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpLogRecordExporterBuilder builder = this.httpBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("logs", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            builder.setMeterProvider(this.meterProviderRef::get);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcLogRecordExporterBuilder builder = this.grpcBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("logs", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            builder.setMeterProvider(this.meterProviderRef::get);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP logs protocol: " + protocol);
    }

    public String getName() {
        return "otlp";
    }

    OtlpHttpLogRecordExporterBuilder httpBuilder() {
        return OtlpHttpLogRecordExporter.builder();
    }

    OtlpGrpcLogRecordExporterBuilder grpcBuilder() {
        return OtlpGrpcLogRecordExporter.builder();
    }

    public void afterAutoConfigure(OpenTelemetrySdk sdk) {
        this.meterProviderRef.set(sdk.getMeterProvider());
    }
}

