/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import java.util.Objects;

public class SnapshotContext {
    private long snapshotId;
    private WriteOperationType operation;
    private long addedRowCount;
    private long deletedRowCount;

    private SnapshotContext() {
    }

    public SnapshotContext(long snapshotId) {
        this.snapshotId = snapshotId;
        this.operation = null;
        this.addedRowCount = 0L;
        this.deletedRowCount = 0L;
    }

    public SnapshotContext(long snapshotId, WriteOperationType operation, long addedRowCount, long deletedRowCount) {
        this.snapshotId = snapshotId;
        this.operation = operation;
        this.addedRowCount = addedRowCount;
        this.deletedRowCount = deletedRowCount;
    }

    public long getSnapshotId() {
        return this.snapshotId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotContext that = (SnapshotContext)o;
        return this.snapshotId == that.snapshotId;
    }

    public int hashCode() {
        return Objects.hash(this.snapshotId);
    }

    public WriteOperationType getOperation() {
        return this.operation;
    }

    public long getAddedRowCount() {
        return this.addedRowCount;
    }

    public long getDeletedRowCount() {
        return this.deletedRowCount;
    }

    public String toString() {
        return "SnapshotContext{snapshotId=" + this.snapshotId + ", operation=" + this.operation + ", addedRowCount=" + this.addedRowCount + ", deletedRowCount=" + this.deletedRowCount + "}";
    }

    public static enum WriteOperationType {
        APPEND,
        REPLACE,
        OVERWRITE,
        DELETE,
        UNKNOWN;

    }
}

