/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jdo.FetchPlan;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOQueryInterruptedException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.spi.JDOPermission;
import org.datanucleus.api.jdo.JDOAdapter;
import org.datanucleus.api.jdo.JDOExtent;
import org.datanucleus.api.jdo.JDOFetchPlan;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.store.query.Extent;
import org.datanucleus.store.query.NoQueryResultsException;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryInterruptedException;
import org.datanucleus.store.query.QueryTimeoutException;
import org.datanucleus.util.Localiser;

public class JDOQuery<T>
implements javax.jdo.Query<T> {
    public static final String PROPERTY_CLOSEABLE_QUERY = "datanucleus.query.closeable";
    private static final long serialVersionUID = -204134873012573162L;
    public static final String JDOQL_QUERY_LANGUAGE = "javax.jdo.query.JDOQL";
    public static final String JPQL_QUERY_LANGUAGE = "javax.jdo.query.JPQL";
    public static final String SQL_QUERY_LANGUAGE = "javax.jdo.query.SQL";
    transient PersistenceManager pm;
    Query<T> query;
    private boolean closed = false;
    String language;
    JDOFetchPlan fetchPlan = null;
    Map parameterValueByName = null;
    Object[] parameterValues = null;

    public JDOQuery(PersistenceManager pm, Query<T> query, String language) {
        this.pm = pm;
        this.query = query;
        this.language = language;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closeAll();
        Boolean closeableQuery = this.query.getExecutionContext().getBooleanProperty(PROPERTY_CLOSEABLE_QUERY);
        if (closeableQuery == Boolean.TRUE) {
            if (this.fetchPlan != null) {
                this.fetchPlan.clearGroups();
                this.fetchPlan = null;
            }
            this.parameterValueByName = null;
            this.parameterValues = null;
            this.pm = null;
            this.query = null;
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close(Object queryResult) {
        this.assertIsOpen();
        this.query.close(queryResult);
    }

    public void closeAll() {
        this.assertIsOpen();
        this.query.closeAll();
    }

    public void compile() {
        this.assertIsOpen();
        try {
            this.query.compile();
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void declareImports(String imports) {
        this.assertIsOpen();
        try {
            this.query.declareImports(imports);
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void declareParameters(String parameters) {
        this.assertIsOpen();
        try {
            this.query.declareExplicitParameters(parameters);
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void declareVariables(String variables) {
        this.assertIsOpen();
        try {
            this.query.declareExplicitVariables(variables);
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public javax.jdo.Query<T> imports(String imports) {
        this.assertIsOpen();
        this.declareImports(imports);
        return this;
    }

    public javax.jdo.Query<T> parameters(String parameters) {
        this.assertIsOpen();
        this.declareParameters(parameters);
        return this;
    }

    public javax.jdo.Query<T> variables(String variables) {
        this.assertIsOpen();
        this.declareVariables(variables);
        return this;
    }

    public javax.jdo.Query<T> setParameters(Object ... paramValues) {
        this.assertIsOpen();
        this.parameterValueByName = null;
        this.parameterValues = paramValues;
        return this;
    }

    public javax.jdo.Query<T> setNamedParameters(Map<String, ?> paramMap) {
        this.assertIsOpen();
        this.parameterValueByName = paramMap;
        this.parameterValues = null;
        return this;
    }

    public Object execute() {
        this.assertIsOpen();
        this.parameterValueByName = null;
        this.parameterValues = null;
        return this.executeInternal();
    }

    public Object execute(Object p1) {
        this.assertIsOpen();
        this.parameterValueByName = null;
        this.parameterValues = new Object[]{p1};
        return this.executeInternal();
    }

    public Object execute(Object p1, Object p2) {
        this.assertIsOpen();
        this.parameterValueByName = null;
        this.parameterValues = new Object[]{p1, p2};
        return this.executeInternal();
    }

    public Object execute(Object p1, Object p2, Object p3) {
        this.assertIsOpen();
        this.parameterValueByName = null;
        this.parameterValues = new Object[]{p1, p2, p3};
        return this.executeInternal();
    }

    public Object executeWithArray(Object ... parameterValues) {
        this.assertIsOpen();
        this.parameterValueByName = null;
        this.parameterValues = parameterValues;
        return this.executeInternal();
    }

    public Object executeWithMap(Map parameters) {
        this.assertIsOpen();
        this.parameterValueByName = parameters;
        this.parameterValues = null;
        return this.executeInternal();
    }

    public List<T> executeList() {
        this.assertIsOpen();
        if (this.query.getResult() != null) {
            throw new JDOUserException("Cannot call executeXXX method when query has result set to " + this.query.getResult() + ". Use executeResultList() instead");
        }
        return (List)this.executeInternal();
    }

    public T executeUnique() {
        this.assertIsOpen();
        this.query.setUnique(true);
        if (this.query.getResult() != null) {
            throw new JDOUserException("Cannot call executeXXX method when query has result set to " + this.query.getResult() + ". Use executeResultUnique() instead");
        }
        return (T)this.executeInternal();
    }

    public <R> List<R> executeResultList(Class<R> resultCls) {
        this.assertIsOpen();
        if (resultCls == null) {
            throw new JDOUserException("Result Class must be specified");
        }
        this.query.setResultClass(resultCls);
        return (List)this.executeInternal();
    }

    public <R> R executeResultUnique(Class<R> resultCls) {
        this.assertIsOpen();
        this.query.setUnique(true);
        if (resultCls == null) {
            throw new JDOUserException("Result Class must be specified");
        }
        this.query.setResultClass(resultCls);
        return (R)this.executeInternal();
    }

    public List<Object> executeResultList() {
        this.assertIsOpen();
        if (this.query.getResult() == null) {
            throw new JDOUserException("Cannot call executeResultList method when query has result unset. Call executeList instead.");
        }
        return (List)this.executeInternal();
    }

    public Object executeResultUnique() {
        this.assertIsOpen();
        this.query.setUnique(true);
        if (this.query.getResult() == null) {
            throw new JDOUserException("Cannot call executeResultUnique method when query has result unset. Call executeUnique instead.");
        }
        return this.executeInternal();
    }

    protected Object executeInternal() {
        try {
            if (this.parameterValues != null) {
                Object object = this.query.executeWithArray(this.parameterValues);
                return object;
            }
            if (this.parameterValueByName != null) {
                Object object = this.query.executeWithMap(this.parameterValueByName);
                return object;
            }
            Object object = this.query.execute();
            return object;
        }
        catch (NoQueryResultsException nqre) {
            Object var2_8 = null;
            return var2_8;
        }
        catch (QueryTimeoutException qte) {
            throw new JDODataStoreException("Query has timed out : " + qte.getMessage());
        }
        catch (QueryInterruptedException qie) {
            throw new JDOQueryInterruptedException("Query has been cancelled : " + qie.getMessage());
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
        finally {
            this.parameterValueByName = null;
            this.parameterValues = null;
        }
    }

    public long deletePersistentAll() {
        this.assertIsOpen();
        return this.deletePersistentInternal();
    }

    public long deletePersistentAll(Object ... parameters) {
        this.assertIsOpen();
        this.parameterValueByName = null;
        this.parameterValues = parameters;
        return this.deletePersistentInternal();
    }

    public long deletePersistentAll(Map parameters) {
        this.assertIsOpen();
        this.parameterValueByName = parameters;
        this.parameterValues = null;
        return this.deletePersistentInternal();
    }

    protected long deletePersistentInternal() {
        try {
            if (this.parameterValues != null) {
                long l = this.query.deletePersistentAll(this.parameterValues);
                return l;
            }
            if (this.parameterValueByName != null) {
                long l = this.query.deletePersistentAll(this.parameterValueByName);
                return l;
            }
            long l = this.query.deletePersistentAll();
            return l;
        }
        catch (NoQueryResultsException nqre) {
            long l = 0L;
            return l;
        }
        catch (QueryTimeoutException qte) {
            throw new JDODataStoreException("Query has timed out : " + qte.getMessage());
        }
        catch (QueryInterruptedException qie) {
            throw new JDOQueryInterruptedException("Query has been cancelled : " + qie.getMessage());
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
        finally {
            this.parameterValueByName = null;
            this.parameterValues = null;
        }
    }

    public void cancelAll() {
        this.assertIsOpen();
        try {
            this.query.cancel();
        }
        catch (NucleusException ne) {
            throw new JDOException("Error in calling Query.cancelAll. See the nested exception", (Throwable)ne);
        }
        catch (UnsupportedOperationException uoe) {
            throw new JDOUnsupportedOptionException();
        }
    }

    public void cancel(Thread thr) {
        this.assertIsOpen();
        try {
            this.query.cancel(thr);
        }
        catch (NucleusException ne) {
            throw new JDOException("Error in calling Query.cancelAll. See the nested exception", (Throwable)ne);
        }
        catch (UnsupportedOperationException uoe) {
            throw new JDOUnsupportedOptionException();
        }
    }

    public void setCandidates(javax.jdo.Extent<T> extent) {
        this.assertIsOpen();
        try {
            if (extent == null) {
                this.query.setCandidates((Extent)null);
            } else {
                this.query.setCandidates(((JDOExtent)extent).getExtent());
            }
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void setCandidates(Collection<T> pcs) {
        this.assertIsOpen();
        try {
            this.query.setCandidates(pcs);
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void setClass(Class<T> candidateClass) {
        this.assertIsOpen();
        try {
            this.query.setCandidateClass(candidateClass);
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void addExtension(String key, Object value) {
        this.assertIsOpen();
        this.query.addExtension(key, value);
    }

    public void setExtensions(Map extensions) {
        this.assertIsOpen();
        this.query.setExtensions(extensions);
    }

    public javax.jdo.Query<T> extension(String key, Object value) {
        this.assertIsOpen();
        this.addExtension(key, value);
        return this;
    }

    public javax.jdo.Query<T> extensions(Map values) {
        this.assertIsOpen();
        this.setExtensions(values);
        return this;
    }

    public FetchPlan getFetchPlan() {
        this.assertIsOpen();
        if (this.fetchPlan == null) {
            this.fetchPlan = new JDOFetchPlan(this.query.getFetchPlan());
        }
        return this.fetchPlan;
    }

    public javax.jdo.Query<T> filter(String filter) {
        this.assertIsOpen();
        this.setFilter(filter);
        return this;
    }

    public void setFilter(String filter) {
        this.assertIsOpen();
        try {
            this.query.setFilter(filter);
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public javax.jdo.Query<T> groupBy(String grouping) {
        this.assertIsOpen();
        this.setGrouping(grouping);
        return this;
    }

    public void setGrouping(String grouping) {
        this.assertIsOpen();
        try {
            this.query.setGrouping(grouping);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    public boolean getIgnoreCache() {
        this.assertIsOpen();
        return this.query.getIgnoreCache();
    }

    public void setIgnoreCache(boolean ignoreCache) {
        this.assertIsOpen();
        this.query.setIgnoreCache(ignoreCache);
    }

    public javax.jdo.Query<T> ignoreCache(boolean flag) {
        this.assertIsOpen();
        this.setIgnoreCache(flag);
        return this;
    }

    public javax.jdo.Query<T> orderBy(String ordering) {
        this.assertIsOpen();
        this.setOrdering(ordering);
        return this;
    }

    public void setOrdering(String ordering) {
        this.assertIsOpen();
        try {
            this.query.setOrdering(ordering);
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public PersistenceManager getPersistenceManager() {
        this.assertIsOpen();
        return this.pm;
    }

    public javax.jdo.Query<T> range(long fromIncl, long toExcl) {
        this.assertIsOpen();
        this.setRange(fromIncl, toExcl);
        return this;
    }

    public javax.jdo.Query<T> range(String range) {
        this.assertIsOpen();
        this.setRange(range);
        return this;
    }

    public void setRange(String range) {
        this.assertIsOpen();
        try {
            this.query.setRange(range);
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void setRange(long fromIncl, long toExcl) {
        this.assertIsOpen();
        try {
            this.query.setRange(fromIncl, toExcl);
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public javax.jdo.Query<T> result(String result) {
        this.assertIsOpen();
        this.setResult(result);
        return this;
    }

    public void setResult(String result) {
        this.assertIsOpen();
        try {
            this.query.setResult(result);
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void setResultClass(Class result_cls) {
        this.assertIsOpen();
        try {
            this.query.setResultClass(result_cls);
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public void setDatastoreReadTimeoutMillis(Integer timeout) {
        this.assertIsOpen();
        try {
            this.query.setDatastoreReadTimeoutMillis(timeout);
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public Integer getDatastoreReadTimeoutMillis() {
        this.assertIsOpen();
        return this.query.getDatastoreReadTimeoutMillis();
    }

    public void setDatastoreWriteTimeoutMillis(Integer timeout) {
        this.assertIsOpen();
        try {
            this.query.setDatastoreWriteTimeoutMillis(timeout);
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public Integer getDatastoreWriteTimeoutMillis() {
        this.assertIsOpen();
        return this.query.getDatastoreWriteTimeoutMillis();
    }

    public javax.jdo.Query<T> datastoreReadTimeoutMillis(Integer interval) {
        this.assertIsOpen();
        this.setDatastoreReadTimeoutMillis(interval);
        return this;
    }

    public javax.jdo.Query<T> datastoreWriteTimeoutMillis(Integer interval) {
        this.assertIsOpen();
        this.setDatastoreWriteTimeoutMillis(interval);
        return this;
    }

    public void setUnique(boolean unique) {
        this.assertIsOpen();
        try {
            this.query.setUnique(unique);
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public boolean isUnmodifiable() {
        this.assertIsOpen();
        return this.query.isUnmodifiable();
    }

    public void setUnmodifiable() {
        this.assertIsOpen();
        this.query.setUnmodifiable();
    }

    public javax.jdo.Query<T> unmodifiable() {
        this.assertIsOpen();
        this.setUnmodifiable();
        return this;
    }

    public void addSubquery(javax.jdo.Query sub, String variableDecl, String candidateExpr) {
        this.assertIsOpen();
        this.addSubquery(sub, variableDecl, candidateExpr, (Map)null);
    }

    public void addSubquery(javax.jdo.Query sub, String variableDecl, String candidateExpr, String parameter) {
        this.assertIsOpen();
        HashMap<Integer, String> paramMap = new HashMap<Integer, String>();
        if (parameter != null) {
            paramMap.put(0, parameter);
        }
        this.addSubquery(sub, variableDecl, candidateExpr, paramMap);
    }

    public void addSubquery(javax.jdo.Query sub, String variableDecl, String candidateExpr, String ... parameters) {
        this.assertIsOpen();
        HashMap<Integer, String> paramMap = new HashMap<Integer, String>();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                paramMap.put(i, parameters[i]);
            }
        }
        this.addSubquery(sub, variableDecl, candidateExpr, paramMap);
    }

    public void addSubquery(javax.jdo.Query sub, String variableDecl, String candidateExpr, Map parameters) {
        this.assertIsOpen();
        try {
            Query<T> subquery = null;
            if (sub != null) {
                subquery = ((JDOQuery)sub).query;
            }
            this.query.addSubquery(subquery, variableDecl, candidateExpr, parameters);
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    public javax.jdo.Query<T> subquery(javax.jdo.Query sub, String variableDecl, String candidateExpr) {
        this.assertIsOpen();
        this.addSubquery(sub, variableDecl, candidateExpr);
        return this;
    }

    public javax.jdo.Query<T> subquery(javax.jdo.Query sub, String variableDecl, String candidateExpr, String parameter) {
        this.assertIsOpen();
        this.addSubquery(sub, variableDecl, candidateExpr, parameter);
        return this;
    }

    public javax.jdo.Query<T> subquery(javax.jdo.Query sub, String variableDecl, String candidateExpr, String ... parameters) {
        this.assertIsOpen();
        this.addSubquery(sub, variableDecl, candidateExpr, parameters);
        return this;
    }

    public javax.jdo.Query<T> subquery(javax.jdo.Query sub, String variableDecl, String candidateExpr, Map parameters) {
        this.assertIsOpen();
        this.addSubquery(sub, variableDecl, candidateExpr, parameters);
        return this;
    }

    public Boolean getSerializeRead() {
        this.assertIsOpen();
        return this.query.getSerializeRead();
    }

    public void setSerializeRead(Boolean serialize) {
        this.assertIsOpen();
        this.query.setSerializeRead(serialize);
    }

    public javax.jdo.Query<T> serializeRead(Boolean serialize) {
        this.assertIsOpen();
        this.setSerializeRead(serialize);
        return this;
    }

    public Query<T> getInternalQuery() {
        return this.query;
    }

    public String getLanguage() {
        this.assertIsOpen();
        return this.language;
    }

    public javax.jdo.Query<T> saveAsNamedQuery(String name) {
        this.assertIsOpen();
        JDOPersistenceManagerFactory.checkJDOPermission(JDOPermission.GET_METADATA);
        Object queryName = null;
        queryName = this.query.getCandidateClassName() != null ? this.query.getCandidateClassName() + "_" + name : name;
        QueryMetaData qmd = new QueryMetaData((String)queryName);
        qmd.setLanguage(this.language);
        qmd.setQuery(this.query.toString());
        qmd.setResultClass(this.query.getResultClassName());
        qmd.setUnique(this.query.isUnique());
        Map queryExts = this.query.getExtensions();
        if (queryExts != null && !queryExts.isEmpty()) {
            for (Map.Entry queryExtEntry : queryExts.entrySet()) {
                qmd.addExtension((String)queryExtEntry.getKey(), "" + queryExtEntry.getValue());
            }
        }
        this.query.getExecutionContext().getMetaDataManager().registerNamedQuery(qmd);
        return this;
    }

    public String toString() {
        return this.query != null ? this.query.toString() : "(closed query)";
    }

    public Object getNativeQuery() {
        this.assertIsOpen();
        return this.query.getNativeQuery();
    }

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(Localiser.msg((String)"011100"));
        }
    }
}

