/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class ChangelogUtil {
    private static final Schema CHANGELOG_METADATA = new Schema(MetadataColumns.CHANGE_TYPE, MetadataColumns.CHANGE_ORDINAL, MetadataColumns.COMMIT_SNAPSHOT_ID);
    private static final Set<Integer> CHANGELOG_METADATA_FIELD_IDS = CHANGELOG_METADATA.columns().stream().map(Types.NestedField::fieldId).collect(Collectors.toSet());

    private ChangelogUtil() {
    }

    public static Schema changelogSchema(Schema tableSchema) {
        return TypeUtil.join(tableSchema, CHANGELOG_METADATA);
    }

    public static Schema dropChangelogMetadata(Schema changelogSchema) {
        return TypeUtil.selectNot(changelogSchema, CHANGELOG_METADATA_FIELD_IDS);
    }
}

