/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

class IdToOrcName
extends TypeUtil.SchemaVisitor<Map<Integer, String>> {
    private static final Joiner DOT = Joiner.on(".");
    private final Deque<String> fieldNames = Lists.newLinkedList();
    private final Map<Integer, String> idToName = Maps.newHashMap();

    IdToOrcName() {
    }

    @Override
    public void beforeField(Types.NestedField field) {
        this.fieldNames.push(field.name());
    }

    @Override
    public void afterField(Types.NestedField field) {
        this.fieldNames.pop();
    }

    @Override
    public void beforeListElement(Types.NestedField elementField) {
        this.fieldNames.push("_elem");
    }

    @Override
    public void afterListElement(Types.NestedField elementField) {
        this.fieldNames.pop();
    }

    @Override
    public void beforeMapKey(Types.NestedField keyField) {
        this.fieldNames.push("_key");
    }

    @Override
    public void afterMapKey(Types.NestedField keyField) {
        this.fieldNames.pop();
    }

    @Override
    public void beforeMapValue(Types.NestedField valueField) {
        this.fieldNames.push("_value");
    }

    @Override
    public void afterMapValue(Types.NestedField valueField) {
        this.fieldNames.pop();
    }

    @Override
    public Map<Integer, String> schema(Schema schema, Map<Integer, String> structResult) {
        return structResult;
    }

    @Override
    public Map<Integer, String> struct(Types.StructType struct, List<Map<Integer, String>> fieldResults) {
        return this.idToName;
    }

    @Override
    public Map<Integer, String> field(Types.NestedField field, Map<Integer, String> fieldResult) {
        this.addField(field.name(), field.fieldId());
        return this.idToName;
    }

    @Override
    public Map<Integer, String> list(Types.ListType list, Map<Integer, String> elementResult) {
        this.addField("_elem", list.elementId());
        return this.idToName;
    }

    @Override
    public Map<Integer, String> map(Types.MapType map, Map<Integer, String> keyResult, Map<Integer, String> valueResult) {
        this.addField("_key", map.keyId());
        this.addField("_value", map.valueId());
        return this.idToName;
    }

    @Override
    public Map<Integer, String> primitive(Type.PrimitiveType primitive) {
        return this.idToName;
    }

    private void addField(String name, int fieldId) {
        ArrayList<String> fullName = Lists.newArrayList(this.fieldNames.descendingIterator());
        fullName.add(name);
        this.idToName.put(fieldId, DOT.join(Iterables.transform(fullName, this::quoteName)));
    }

    private String quoteName(String name) {
        String escapedName = name.replace("`", "``");
        return "`" + escapedName + "`";
    }
}

