/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.flush;

import org.datanucleus.flush.SCOOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.types.scostore.ListStore;
import org.datanucleus.store.types.scostore.Store;

public class ListSetOperation<E>
implements SCOOperation {
    final DNStateManager sm;
    final int fieldNumber;
    final ListStore<E> store;
    final int index;
    final E value;
    boolean allowCascadeDelete = true;

    public ListSetOperation(DNStateManager sm, ListStore<E> store, int index, E value, boolean allowCascadeDelete) {
        this.sm = sm;
        this.fieldNumber = store.getOwnerMemberMetaData().getAbsoluteFieldNumber();
        this.store = store;
        this.index = index;
        this.value = value;
        this.allowCascadeDelete = allowCascadeDelete;
    }

    public ListSetOperation(DNStateManager sm, int fieldNum, int index, E value, boolean allowCascadeDelete) {
        this.sm = sm;
        this.fieldNumber = fieldNum;
        this.store = null;
        this.index = index;
        this.value = value;
        this.allowCascadeDelete = allowCascadeDelete;
    }

    @Override
    public AbstractMemberMetaData getMemberMetaData() {
        return this.store != null ? this.store.getOwnerMemberMetaData() : this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(this.fieldNumber);
    }

    @Override
    public void perform() {
        if (this.store != null) {
            this.store.set(this.sm, this.index, this.value, this.allowCascadeDelete);
        }
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    @Override
    public DNStateManager getStateManager() {
        return this.sm;
    }

    public String toString() {
        return "LIST SET : " + this.sm + " field=" + this.getMemberMetaData().getName() + " index=" + this.index;
    }
}

