/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.util.StringUtils;

public class QueryResultMetaData
extends MetaData {
    private static final long serialVersionUID = -3001099437789070838L;
    protected final String name;
    protected List<PersistentTypeMapping> persistentTypeMappings;
    protected List<String> scalarColumns;
    protected List<ConstructorTypeMapping> ctrTypeMappings;

    public QueryResultMetaData(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addPersistentTypeMapping(String className, Map<String, String> fieldColumnMap, String discrimColumn) {
        if (this.persistentTypeMappings == null) {
            this.persistentTypeMappings = new ArrayList<PersistentTypeMapping>();
        }
        PersistentTypeMapping m = new PersistentTypeMapping();
        m.className = className;
        m.discriminatorColumn = StringUtils.isWhitespace(discrimColumn) ? null : discrimColumn;
        m.fieldColumnMap = fieldColumnMap;
        this.persistentTypeMappings.add(m);
    }

    public void addMappingForPersistentTypeMapping(String className, String fieldName, String columnName) {
        PersistentTypeMapping m = null;
        if (this.persistentTypeMappings == null) {
            this.persistentTypeMappings = new ArrayList<PersistentTypeMapping>();
        } else {
            for (PersistentTypeMapping mapping : this.persistentTypeMappings) {
                if (!mapping.className.equals(className)) continue;
                m = mapping;
                break;
            }
        }
        if (m == null) {
            m = new PersistentTypeMapping();
            m.className = className;
        }
        if (m.fieldColumnMap == null) {
            m.fieldColumnMap = new HashMap<String, String>();
        }
        m.fieldColumnMap.put(fieldName, columnName);
    }

    public PersistentTypeMapping[] getPersistentTypeMappings() {
        if (this.persistentTypeMappings == null) {
            return null;
        }
        return this.persistentTypeMappings.toArray(new PersistentTypeMapping[this.persistentTypeMappings.size()]);
    }

    public void addScalarColumn(String columnName) {
        if (this.scalarColumns == null) {
            this.scalarColumns = new ArrayList<String>();
        }
        this.scalarColumns.add(columnName);
    }

    public String[] getScalarColumns() {
        if (this.scalarColumns == null) {
            return null;
        }
        return this.scalarColumns.toArray(new String[this.scalarColumns.size()]);
    }

    public void addConstructorTypeMapping(String className, List<ConstructorTypeColumn> colNames) {
        if (this.ctrTypeMappings == null) {
            this.ctrTypeMappings = new ArrayList<ConstructorTypeMapping>();
        }
        ConstructorTypeMapping m = new ConstructorTypeMapping();
        m.className = className;
        m.ctrColumns = new ArrayList<ConstructorTypeColumn>(colNames);
        this.ctrTypeMappings.add(m);
    }

    public ConstructorTypeMapping[] getConstructorTypeMappings() {
        if (this.ctrTypeMappings == null) {
            return null;
        }
        return this.ctrTypeMappings.toArray(new ConstructorTypeMapping[this.ctrTypeMappings.size()]);
    }

    public static class ConstructorTypeColumn {
        String columnName;
        Class javaType;

        public ConstructorTypeColumn(String colName, Class type) {
            this.columnName = colName;
            if (type != Void.TYPE) {
                this.javaType = type;
            }
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class getJavaType() {
            return this.javaType;
        }
    }

    public static class ConstructorTypeMapping {
        String className;
        List<ConstructorTypeColumn> ctrColumns;

        public String getClassName() {
            return this.className;
        }

        public List<ConstructorTypeColumn> getColumnsForConstructor() {
            if (this.ctrColumns == null) {
                return null;
            }
            return this.ctrColumns;
        }
    }

    public static class PersistentTypeMapping {
        String className;
        Map<String, String> fieldColumnMap;
        String discriminatorColumn;

        public String getClassName() {
            return this.className;
        }

        public String getDiscriminatorColumn() {
            return this.discriminatorColumn;
        }

        public String getColumnForField(String fieldName) {
            if (this.fieldColumnMap == null) {
                return null;
            }
            return this.fieldColumnMap.get(fieldName);
        }
    }
}

