/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.inmemory.method;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.query.expression.InvokeExpression;
import org.datanucleus.store.query.expression.Literal;
import org.datanucleus.store.query.expression.ParameterExpression;
import org.datanucleus.store.query.expression.PrimaryExpression;
import org.datanucleus.store.query.inmemory.InMemoryExpressionEvaluator;
import org.datanucleus.store.query.inmemory.InvocationEvaluator;

public class ConcatFunction
implements InvocationEvaluator {
    @Override
    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        String method = expr.getOperation();
        Expression param = expr.getArguments().get(0);
        Object paramValue = null;
        if (param instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)param;
            paramValue = eval.getValueForPrimaryExpression(primExpr);
        } else if (param instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)param;
            paramValue = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (param instanceof Literal) {
            paramValue = ((Literal)param).getLiteral();
        } else {
            throw new NucleusException(method + "(param) where param is instanceof " + param.getClass().getName() + " not supported");
        }
        Expression param2 = expr.getArguments().get(1);
        Object param2Value = null;
        if (param2 instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)param;
            param2Value = eval.getValueForPrimaryExpression(primExpr);
        } else if (param2 instanceof ParameterExpression) {
            ParameterExpression param2Expr = (ParameterExpression)param2;
            param2Value = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), param2Expr);
        } else if (param2 instanceof Literal) {
            param2Value = ((Literal)param).getLiteral();
        } else {
            throw new NucleusException(method + "(param, param2) where param2 is instanceof " + param2.getClass().getName() + " not supported");
        }
        if (paramValue == null) {
            return null;
        }
        return ((String)paramValue).concat((String)param2Value);
    }
}

