/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ClassUtils {
    public static <T> T newInstance(Class<T> type, Class[] parameterTypes, Object[] parameters) {
        try {
            return type.getConstructor(parameterTypes).newInstance(parameters);
        }
        catch (NoSuchMethodException e) {
            throw new NucleusException(Localiser.msg("030004", type.getName(), Arrays.asList(parameterTypes).toString() + " " + Arrays.asList(type.getConstructors()).toString()), new Exception[]{e}).setFatal();
        }
        catch (IllegalAccessException e) {
            throw new NucleusException(Localiser.msg("030005", type.getName()), new Exception[]{e}).setFatal();
        }
        catch (InstantiationException e) {
            throw new NucleusException(Localiser.msg("030006", type.getName()), new Exception[]{e}).setFatal();
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new NucleusException(Localiser.msg("030007", type.getName(), t)).setFatal();
        }
    }

    public static <T> Constructor<T> getConstructorWithArguments(Class<T> cls, Class[] argTypes) {
        block8: {
            try {
                Constructor<?>[] constructors = cls.getConstructors();
                if (constructors == null) break block8;
                for (int i = 0; i < constructors.length; ++i) {
                    Class<?>[] ctrParams = constructors[i].getParameterTypes();
                    boolean ctrIsValid = true;
                    if (ctrParams != null && ctrParams.length == argTypes.length) {
                        for (int j = 0; j < ctrParams.length; ++j) {
                            Class primType = ClassUtils.getPrimitiveTypeForType(argTypes[j]);
                            if (argTypes[j] == null && ctrParams[j].isPrimitive()) {
                                ctrIsValid = false;
                            } else {
                                if (argTypes[j] == null || ctrParams[j].isAssignableFrom(argTypes[j]) || primType != null && ctrParams[j] == primType) continue;
                                ctrIsValid = false;
                            }
                            break;
                        }
                    } else {
                        ctrIsValid = false;
                    }
                    if (!ctrIsValid) continue;
                    return constructors[i];
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> Constructor<T> getConstructorWithArguments(Class<T> cls, Class[] argTypes, boolean[] argTypeCheck) {
        block8: {
            try {
                Constructor<?>[] constructors = cls.getConstructors();
                if (constructors == null) break block8;
                for (int i = 0; i < constructors.length; ++i) {
                    Class<?>[] ctrParams = constructors[i].getParameterTypes();
                    boolean ctrIsValid = true;
                    if (ctrParams != null && ctrParams.length == argTypes.length) {
                        for (int j = 0; j < ctrParams.length && argTypeCheck[j]; ++j) {
                            Class primType = ClassUtils.getPrimitiveTypeForType(argTypes[j]);
                            if (argTypes[j] == null && ctrParams[j].isPrimitive()) {
                                ctrIsValid = false;
                            } else {
                                if (argTypes[j] == null || ctrParams[j].isAssignableFrom(argTypes[j]) || primType != null && ctrParams[j] == primType) continue;
                                ctrIsValid = false;
                            }
                            break;
                        }
                    } else {
                        ctrIsValid = false;
                    }
                    if (!ctrIsValid) continue;
                    return constructors[i];
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Method getMethodWithArgument(Class cls, String methodName, Class argType) {
        Class primitive;
        Method m = ClassUtils.getMethodForClass(cls, methodName, new Class[]{argType});
        if (m == null && (primitive = ClassUtils.getPrimitiveTypeForType(argType)) != null) {
            m = ClassUtils.getMethodForClass(cls, methodName, new Class[]{primitive});
        }
        return m;
    }

    public static Method getMethodForClass(Class cls, String methodName, Class[] argtypes) {
        try {
            return cls.getDeclaredMethod(methodName, argtypes);
        }
        catch (NoSuchMethodException e) {
            if (cls.getSuperclass() != null) {
                return ClassUtils.getMethodForClass(cls.getSuperclass(), methodName, argtypes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Collection<File> getClassFilesForDirectory(File dir, boolean includeNormal, boolean includeInner) {
        if (dir == null) {
            return null;
        }
        HashSet<File> classes = new HashSet<File>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isFile()) {
                    if (!files[i].getName().endsWith(".class")) continue;
                    boolean isInnerClass = ClassUtils.isInnerClass(files[i].getName());
                    if ((!includeNormal || isInnerClass) && (!includeInner || !isInnerClass)) continue;
                    classes.add(files[i]);
                    continue;
                }
                Collection<File> childClasses = ClassUtils.getClassFilesForDirectory(files[i], includeNormal, includeInner);
                if (childClasses == null || childClasses.isEmpty()) continue;
                classes.addAll(childClasses);
            }
        }
        return classes;
    }

    public static Collection<File> getFilesForDirectory(File dir) {
        if (dir == null) {
            return null;
        }
        HashSet<File> files = new HashSet<File>();
        File[] dirFiles = dir.listFiles();
        if (dirFiles != null) {
            for (int i = 0; i < dirFiles.length; ++i) {
                if (dirFiles[i].isFile()) {
                    files.add(dirFiles[i]);
                    continue;
                }
                Collection<File> childFiles = ClassUtils.getFilesForDirectory(dirFiles[i]);
                if (childFiles == null || childFiles.isEmpty()) continue;
                files.addAll(childFiles);
            }
        }
        return files;
    }

    public static String[] getClassNamesForJarFile(String jarFileName) {
        try {
            return ClassUtils.getClassNamesForJarFile(new JarFile(jarFileName));
        }
        catch (IOException ioe) {
            NucleusLogger.GENERAL.warn("Error opening the jar file " + jarFileName + " : " + ioe.getMessage());
            return null;
        }
    }

    public static String[] getClassNamesForJarFile(URL jarFileURL) {
        File jarFile = new File(jarFileURL.getFile());
        try {
            return ClassUtils.getClassNamesForJarFile(new JarFile(jarFile));
        }
        catch (IOException ioe) {
            NucleusLogger.GENERAL.warn("Error opening the jar file " + jarFileURL.getFile() + " : " + ioe.getMessage());
            return null;
        }
    }

    public static String[] getClassNamesForJarFile(URI jarFileURI) {
        try {
            return ClassUtils.getClassNamesForJarFile(jarFileURI.toURL());
        }
        catch (MalformedURLException mue) {
            throw new NucleusException("Error opening the jar file " + jarFileURI, mue);
        }
    }

    private static String[] getClassNamesForJarFile(JarFile jar) {
        Enumeration<JarEntry> jarEntries = jar.entries();
        HashSet<String> classes = new HashSet<String>();
        while (jarEntries.hasMoreElements()) {
            String entry = jarEntries.nextElement().getName();
            if (!entry.endsWith(".class") || ClassUtils.isInnerClass(entry)) continue;
            String className = entry.substring(0, entry.length() - 6);
            className = className.replace(File.separatorChar, '.');
            classes.add(className);
        }
        return classes.toArray(new String[classes.size()]);
    }

    public static String[] getPackageJdoFilesForJarFile(String jarFileName) {
        try {
            return ClassUtils.getFileNamesWithSuffixForJarFile(new JarFile(jarFileName), "package.jdo");
        }
        catch (IOException ioe) {
            NucleusLogger.GENERAL.warn("Error opening the jar file " + jarFileName + " : " + ioe.getMessage());
            return null;
        }
    }

    public static String[] getPackageJdoFilesForJarFile(URL jarFileURL) {
        File jarFile = new File(jarFileURL.getFile());
        try {
            return ClassUtils.getFileNamesWithSuffixForJarFile(new JarFile(jarFile), "package.jdo");
        }
        catch (IOException ioe) {
            NucleusLogger.GENERAL.warn("Error opening the jar file " + jarFileURL.getFile() + " : " + ioe.getMessage());
            return null;
        }
    }

    public static String[] getPackageJdoFilesForJarFile(URI jarFileURI) {
        URL jarFileURL = null;
        try {
            jarFileURL = jarFileURI.toURL();
        }
        catch (MalformedURLException mue) {
            throw new NucleusException("JAR file at " + jarFileURI + " not openable. Invalid URL");
        }
        return ClassUtils.getPackageJdoFilesForJarFile(jarFileURL);
    }

    private static String[] getFileNamesWithSuffixForJarFile(JarFile jar, String suffix) {
        Enumeration<JarEntry> jarEntries = jar.entries();
        HashSet<String> files = new HashSet<String>();
        while (jarEntries.hasMoreElements()) {
            String entry = jarEntries.nextElement().getName();
            if (!entry.endsWith(suffix)) continue;
            files.add(entry);
        }
        return files.toArray(new String[files.size()]);
    }

    public static String[] getClassNamesForDirectoryAndBelow(File dir) {
        if (dir == null) {
            return null;
        }
        Collection<File> classFiles = ClassUtils.getClassFilesForDirectory(dir, true, false);
        if (classFiles == null || classFiles.isEmpty()) {
            return null;
        }
        String[] classNames = new String[classFiles.size()];
        Iterator<File> iter = classFiles.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String filename = iter.next().getAbsolutePath();
            String classname = filename.substring(dir.getAbsolutePath().length() + 1, filename.length() - 6);
            classNames[i++] = classname.replace(File.separatorChar, '.');
        }
        return classNames;
    }

    public static boolean isInnerClass(String class_name) {
        if (class_name == null) {
            return false;
        }
        return class_name.indexOf(36) >= 0;
    }

    public static boolean hasDefaultConstructor(Class cls) {
        if (cls == null) {
            return false;
        }
        try {
            cls.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Collection<Class<?>> getSuperclasses(Class<?> cls) {
        ArrayList result = new ArrayList();
        for (Class<?> superclass = cls.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            result.add(superclass);
        }
        return result;
    }

    public static Collection<Class<?>> getSuperinterfaces(Class<?> cls) {
        ArrayList result = new ArrayList();
        ClassUtils.collectSuperinterfaces(cls, result);
        return result;
    }

    private static void collectSuperinterfaces(Class<?> c, List<Class<?>> result) {
        for (Class<?> i : c.getInterfaces()) {
            if (result.contains(i)) continue;
            result.add(i);
            ClassUtils.collectSuperinterfaces(i, result);
        }
    }

    public static Field getFieldForClass(Class cls, String fieldName) {
        try {
            while (true) {
                try {
                    return cls.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException e) {
                    if ((cls = cls.getSuperclass()) != null) continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Method getGetterMethodForClass(Class cls, String beanName) {
        Method getter = ClassUtils.findDeclaredMethodInHeirarchy(cls, ClassUtils.getJavaBeanGetterName(beanName, false), new Class[0]);
        if (getter == null) {
            getter = ClassUtils.findDeclaredMethodInHeirarchy(cls, ClassUtils.getJavaBeanGetterName(beanName, true), new Class[0]);
        }
        return getter;
    }

    public static Method getSetterMethodForClass(Class cls, String beanName, Class type) {
        return ClassUtils.findDeclaredMethodInHeirarchy(cls, ClassUtils.getJavaBeanSetterName(beanName), type);
    }

    private static Method findDeclaredMethodInHeirarchy(Class cls, String methodName, Class ... parameterTypes) {
        try {
            while (true) {
                try {
                    return cls.getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException e) {
                    if ((cls = cls.getSuperclass()) != null) continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getWrapperTypeNameForPrimitiveTypeName(String typeName) {
        if (typeName.equals("boolean")) {
            return ClassNameConstants.JAVA_LANG_BOOLEAN;
        }
        if (typeName.equals("byte")) {
            return ClassNameConstants.JAVA_LANG_BYTE;
        }
        if (typeName.equals("char")) {
            return ClassNameConstants.JAVA_LANG_CHARACTER;
        }
        if (typeName.equals("double")) {
            return ClassNameConstants.JAVA_LANG_DOUBLE;
        }
        if (typeName.equals("float")) {
            return ClassNameConstants.JAVA_LANG_FLOAT;
        }
        if (typeName.equals("int")) {
            return ClassNameConstants.JAVA_LANG_INTEGER;
        }
        if (typeName.equals("long")) {
            return ClassNameConstants.JAVA_LANG_LONG;
        }
        if (typeName.equals("short")) {
            return ClassNameConstants.JAVA_LANG_SHORT;
        }
        return typeName;
    }

    public static Class getWrapperTypeForPrimitiveType(Class type) {
        if (type == Boolean.TYPE) {
            return ClassConstants.JAVA_LANG_BOOLEAN;
        }
        if (type == Byte.TYPE) {
            return ClassConstants.JAVA_LANG_BYTE;
        }
        if (type == Character.TYPE) {
            return ClassConstants.JAVA_LANG_CHARACTER;
        }
        if (type == Double.TYPE) {
            return ClassConstants.JAVA_LANG_DOUBLE;
        }
        if (type == Float.TYPE) {
            return ClassConstants.JAVA_LANG_FLOAT;
        }
        if (type == Integer.TYPE) {
            return ClassConstants.JAVA_LANG_INTEGER;
        }
        if (type == Long.TYPE) {
            return ClassConstants.JAVA_LANG_LONG;
        }
        if (type == Short.TYPE) {
            return ClassConstants.JAVA_LANG_SHORT;
        }
        return null;
    }

    public static Class getPrimitiveTypeForType(Class type) {
        if (type == Boolean.class) {
            return ClassConstants.BOOLEAN;
        }
        if (type == Byte.class) {
            return ClassConstants.BYTE;
        }
        if (type == Character.class) {
            return ClassConstants.CHAR;
        }
        if (type == Double.class) {
            return ClassConstants.DOUBLE;
        }
        if (type == Float.class) {
            return ClassConstants.FLOAT;
        }
        if (type == Integer.class) {
            return ClassConstants.INT;
        }
        if (type == Long.class) {
            return ClassConstants.LONG;
        }
        if (type == Short.class) {
            return ClassConstants.SHORT;
        }
        return null;
    }

    public static boolean isPrimitiveWrapperType(String typeName) {
        return typeName.equals(ClassNameConstants.JAVA_LANG_BOOLEAN) || typeName.equals(ClassNameConstants.JAVA_LANG_BYTE) || typeName.equals(ClassNameConstants.JAVA_LANG_CHARACTER) || typeName.equals(ClassNameConstants.JAVA_LANG_DOUBLE) || typeName.equals(ClassNameConstants.JAVA_LANG_FLOAT) || typeName.equals(ClassNameConstants.JAVA_LANG_INTEGER) || typeName.equals(ClassNameConstants.JAVA_LANG_LONG) || typeName.equals(ClassNameConstants.JAVA_LANG_SHORT);
    }

    public static boolean isPrimitiveArrayType(String typeName) {
        return typeName.equals(ClassNameConstants.BOOLEAN_ARRAY) || typeName.equals(ClassNameConstants.BYTE_ARRAY) || typeName.equals(ClassNameConstants.CHAR_ARRAY) || typeName.equals(ClassNameConstants.DOUBLE_ARRAY) || typeName.equals(ClassNameConstants.FLOAT_ARRAY) || typeName.equals(ClassNameConstants.INT_ARRAY) || typeName.equals(ClassNameConstants.LONG_ARRAY) || typeName.equals(ClassNameConstants.SHORT_ARRAY);
    }

    public static boolean isPrimitiveType(String typeName) {
        return typeName.equals(ClassNameConstants.BOOLEAN) || typeName.equals(ClassNameConstants.BYTE) || typeName.equals(ClassNameConstants.CHAR) || typeName.equals(ClassNameConstants.DOUBLE) || typeName.equals(ClassNameConstants.FLOAT) || typeName.equals(ClassNameConstants.INT) || typeName.equals(ClassNameConstants.LONG) || typeName.equals(ClassNameConstants.SHORT);
    }

    public static boolean typesAreCompatible(Class cls1, String clsName2, ClassLoaderResolver clr) {
        if (clr.isAssignableFrom(cls1, clsName2)) {
            return true;
        }
        if (cls1.isPrimitive()) {
            return clr.isAssignableFrom(ClassUtils.getWrapperTypeForPrimitiveType(cls1), clsName2);
        }
        if (ClassUtils.isPrimitiveWrapperType(cls1.getName())) {
            return clr.isAssignableFrom(ClassUtils.getPrimitiveTypeForType(cls1), clsName2);
        }
        return false;
    }

    public static boolean typesAreCompatible(Class cls1, Class cls2) {
        if (cls1.isAssignableFrom(cls2)) {
            return true;
        }
        if (cls1.isPrimitive()) {
            return ClassUtils.getWrapperTypeForPrimitiveType(cls1).isAssignableFrom(cls2);
        }
        return false;
    }

    public static String createFullClassName(String pkg_name, String cls_name) {
        if (StringUtils.isWhitespace(cls_name)) {
            throw new IllegalArgumentException("Class name not specified");
        }
        if (StringUtils.isWhitespace(pkg_name)) {
            return cls_name;
        }
        if (cls_name.indexOf(46) >= 0) {
            return cls_name;
        }
        return pkg_name + "." + cls_name;
    }

    public static String getJavaLangClassForType(String type) {
        String baseType = null;
        baseType = type.lastIndexOf(46) < 0 ? type : type.substring(type.lastIndexOf(46) + 1);
        switch (baseType) {
            case "String": 
            case "Object": 
            case "Boolean": 
            case "Byte": 
            case "Character": 
            case "Double": 
            case "Float": 
            case "Integer": 
            case "Long": 
            case "Short": 
            case "Number": 
            case "StringBuffer": 
            case "StringBuilder": {
                return "java.lang." + baseType;
            }
        }
        return type;
    }

    public static boolean classesAreDescendents(ClassLoaderResolver clr, String class_name_1, String class_name_2) {
        Class class_1 = clr.classForName(class_name_1);
        Class class_2 = clr.classForName(class_name_2);
        if (class_1 == null || class_2 == null) {
            return false;
        }
        return class_1.isAssignableFrom(class_2) || class_2.isAssignableFrom(class_1);
    }

    public static void dumpClassInformation(Class cls) {
        int j;
        Annotation[] annots;
        int i;
        NucleusLogger.GENERAL.info("----------------------------------------");
        NucleusLogger.GENERAL.info("Class Information for class " + cls.getName());
        for (Class<?> superclass : ClassUtils.getSuperclasses(cls)) {
            NucleusLogger.GENERAL.info("    Superclass : " + superclass.getName());
        }
        Class<?>[] interfaces = cls.getInterfaces();
        if (interfaces != null) {
            for (int i2 = 0; i2 < interfaces.length; ++i2) {
                NucleusLogger.GENERAL.info("    Interface : " + interfaces[i2].getName());
            }
        }
        try {
            Method[] methods = cls.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                NucleusLogger.GENERAL.info("    Method : " + methods[i].toString());
                annots = methods[i].getAnnotations();
                if (annots == null) continue;
                for (j = 0; j < annots.length; ++j) {
                    NucleusLogger.GENERAL.info("        annotation=" + annots[j]);
                }
            }
        }
        catch (Exception methods) {
            // empty catch block
        }
        try {
            Field[] fields = cls.getDeclaredFields();
            for (i = 0; i < fields.length; ++i) {
                NucleusLogger.GENERAL.info("    Field : " + fields[i].toString());
                annots = fields[i].getAnnotations();
                if (annots == null) continue;
                for (j = 0; j < annots.length; ++j) {
                    NucleusLogger.GENERAL.info("        annotation=" + annots[j]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        NucleusLogger.GENERAL.info("----------------------------------------");
    }

    public static String getJavaBeanGetterName(String fieldName, boolean isBoolean) {
        if (fieldName == null) {
            return null;
        }
        return ClassUtils.buildJavaBeanName(isBoolean ? "is" : "get", fieldName);
    }

    public static String getJavaBeanSetterName(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        return ClassUtils.buildJavaBeanName("set", fieldName);
    }

    private static String buildJavaBeanName(String prefix, String fieldName) {
        int prefixLength = prefix.length();
        StringBuilder sb = new StringBuilder(prefixLength + fieldName.length());
        sb.append(prefix);
        sb.append(fieldName);
        sb.setCharAt(prefixLength, Character.toUpperCase(sb.charAt(prefixLength)));
        return sb.toString();
    }

    public static String getFieldNameForJavaBeanGetter(String methodName) {
        if (methodName == null) {
            return null;
        }
        if (methodName.startsWith("get")) {
            return ClassUtils.truncateJavaBeanMethodName(methodName, 3);
        }
        if (methodName.startsWith("is")) {
            return ClassUtils.truncateJavaBeanMethodName(methodName, 2);
        }
        return null;
    }

    public static String getFieldNameForJavaBeanSetter(String methodName) {
        if (methodName == null) {
            return null;
        }
        if (methodName.startsWith("set")) {
            return ClassUtils.truncateJavaBeanMethodName(methodName, 3);
        }
        return null;
    }

    private static String truncateJavaBeanMethodName(String methodName, int prefixLength) {
        if (methodName.length() <= prefixLength) {
            return null;
        }
        String truncMethodName = methodName.substring(prefixLength);
        if (truncMethodName.length() == 1) {
            return truncMethodName.toLowerCase();
        }
        char firstChar = truncMethodName.charAt(0);
        if (Character.isUpperCase(firstChar) && Character.isLowerCase(truncMethodName.charAt(1))) {
            return Character.toLowerCase(firstChar) + truncMethodName.substring(1);
        }
        return truncMethodName;
    }

    public static String getClassNameForFileName(String fileName, ClassLoaderResolver clr) {
        if (!fileName.endsWith(".class")) {
            return null;
        }
        String name = fileName.substring(0, fileName.length() - 6);
        name = name.replace(File.separatorChar, '.');
        while (name.indexOf(".") >= 0) {
            String className = name.substring(name.indexOf(46) + 1);
            try {
                Class cls = clr.classForName(className);
                if (cls != null) {
                    return className;
                }
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            name = className;
        }
        return null;
    }

    public static String getClassNameForFileURL(final URL fileURL) throws ClassNotFoundException {
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ClassLoader(){

                    protected Class findClass(String name) throws ClassNotFoundException {
                        InputStream in = null;
                        try {
                            in = new BufferedInputStream(fileURL.openStream());
                            ByteArrayOutputStream byteStr = new ByteArrayOutputStream();
                            int byt = -1;
                            while ((byt = in.read()) != -1) {
                                byteStr.write(byt);
                            }
                            byte[] byteArr = byteStr.toByteArray();
                            Class<?> clazz = this.defineClass(null, byteArr, 0, byteArr.length);
                            return clazz;
                        }
                        catch (RuntimeException rex) {
                            throw rex;
                        }
                        catch (Exception ex) {
                            throw new ClassNotFoundException(name);
                        }
                        finally {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                };
            }
        });
        Class<?> cls = loader.loadClass("garbage");
        return cls != null ? cls.getName() : null;
    }

    public static String getPackageNameForClass(Class cls) {
        if (cls.getPackage() != null) {
            return cls.getPackage().getName();
        }
        int separator = cls.getName().lastIndexOf(46);
        if (separator < 0) {
            return null;
        }
        return cls.getName().substring(0, separator);
    }

    public static String getPackageNameForClassName(String clsName) {
        int separator = clsName.lastIndexOf(46);
        if (separator < 0) {
            return null;
        }
        return clsName.substring(0, separator);
    }

    public static String getClassNameForClass(Class cls) {
        int separator = cls.getName().lastIndexOf(46);
        if (separator < 0) {
            return cls.getName();
        }
        return cls.getName().substring(separator + 1);
    }

    public static Class getClassForGenericType(Type genericType, int pos) {
        ParameterizedType paramtype;
        if (genericType instanceof ParameterizedType && (paramtype = (ParameterizedType)genericType).getActualTypeArguments().length > pos) {
            Type argType = paramtype.getActualTypeArguments()[pos];
            if (argType instanceof Class) {
                return (Class)argType;
            }
            if (argType instanceof ParameterizedType) {
                return (Class)((ParameterizedType)argType).getRawType();
            }
            if (argType instanceof GenericArrayType) {
                Type cmptType = ((GenericArrayType)argType).getGenericComponentType();
                return Array.newInstance((Class)cmptType, 0).getClass();
            }
        }
        return null;
    }

    public static String getCollectionElementType(Field field) {
        Class elementType = ClassUtils.getCollectionElementType(field.getType(), field.getGenericType());
        return elementType != null ? elementType.getName() : null;
    }

    public static String getCollectionElementType(Method method) {
        Class elementType = ClassUtils.getCollectionElementType(method.getReturnType(), method.getGenericReturnType());
        return elementType != null ? elementType.getName() : null;
    }

    public static Class getCollectionElementType(Class type, Type genericType) {
        return ClassUtils.getClassForGenericType(genericType, 0);
    }

    public static String getMapKeyType(Field field) {
        Class keyType = ClassUtils.getMapKeyType(field.getType(), field.getGenericType());
        return keyType != null ? keyType.getName() : null;
    }

    public static String getMapKeyType(Method method) {
        Class keyType = ClassUtils.getMapKeyType(method.getReturnType(), method.getGenericReturnType());
        return keyType != null ? keyType.getName() : null;
    }

    public static Class getMapKeyType(Class type, Type genericType) {
        if (!Map.class.isAssignableFrom(type)) {
            return null;
        }
        return ClassUtils.getClassForGenericType(genericType, 0);
    }

    public static String getMapValueType(Field field) {
        Class valueType = ClassUtils.getMapValueType(field.getType(), field.getGenericType());
        return valueType != null ? valueType.getName() : null;
    }

    public static String getMapValueType(Method method) {
        Class valueType = ClassUtils.getMapValueType(method.getReturnType(), method.getGenericReturnType());
        return valueType != null ? valueType.getName() : null;
    }

    public static Class getMapValueType(Class type, Type genericType) {
        if (!Map.class.isAssignableFrom(type)) {
            return null;
        }
        return ClassUtils.getClassForGenericType(genericType, 1);
    }

    public static int getModifiersForFieldOfClass(ClassLoaderResolver clr, String className, String fieldName) {
        try {
            Class cls = clr.classForName(className);
            Field fld = cls.getDeclaredField(fieldName);
            return fld.getModifiers();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static boolean isReferenceType(Class cls) {
        if (cls == null) {
            return false;
        }
        return cls.isInterface() || cls.getName().equals("java.lang.Object");
    }

    public static boolean isClassPresent(String className, ClassLoaderResolver clr) {
        try {
            clr.classForName(className);
            return true;
        }
        catch (ClassNotResolvedException cnre) {
            return false;
        }
    }

    public static void assertClassForJarExistsInClasspath(ClassLoaderResolver clr, String className, String jarName) {
        try {
            Class cls = clr.classForName(className);
            if (cls == null) {
                throw new NucleusUserException(Localiser.msg("001006", className, jarName));
            }
        }
        catch (Error err) {
            throw new NucleusUserException(Localiser.msg("001006", className, jarName));
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusUserException(Localiser.msg("001006", className, jarName));
        }
    }

    public static boolean stringArrayContainsValue(String[] array, String value) {
        if (value == null || array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!value.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    public static Object getValueOfMethodByReflection(Object object, String methodName, Object ... args) {
        Object methodValue;
        if (object == null) {
            return null;
        }
        final Method method = ClassUtils.getDeclaredMethodPrivileged(object.getClass(), methodName, new Class[0]);
        if (method == null) {
            throw new NucleusUserException("Cannot access method: " + methodName + " in type " + object.getClass());
        }
        try {
            if (!method.canAccess(object)) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            method.setAccessible(true);
                            return null;
                        }
                    });
                }
                catch (SecurityException ex) {
                    throw new NucleusException("Cannot access method: " + methodName, ex).setFatal();
                }
            }
            methodValue = method.invoke(object, args);
        }
        catch (InvocationTargetException e2) {
            throw new NucleusUserException("Cannot access method: " + methodName, e2);
        }
        catch (IllegalArgumentException e2) {
            throw new NucleusUserException("Cannot access method: " + methodName, e2);
        }
        catch (IllegalAccessException e2) {
            throw new NucleusUserException("Cannot access method: " + methodName, e2);
        }
        return methodValue;
    }

    public static Object getValueOfFieldByReflection(Object object, String fieldName) {
        Object fieldValue;
        if (object == null) {
            return null;
        }
        final Field field = ClassUtils.getDeclaredFieldPrivileged(object.getClass(), fieldName);
        if (field == null) {
            throw new NucleusUserException("Cannot access field: " + fieldName + " in type " + object.getClass());
        }
        try {
            if (!field.canAccess(object)) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            field.setAccessible(true);
                            return null;
                        }
                    });
                }
                catch (SecurityException ex) {
                    throw new NucleusException("Cannot access field: " + fieldName, ex).setFatal();
                }
            }
            fieldValue = field.get(object);
        }
        catch (IllegalArgumentException e2) {
            throw new NucleusUserException("Cannot access field: " + fieldName, e2);
        }
        catch (IllegalAccessException e2) {
            throw new NucleusUserException("Cannot access field: " + fieldName, e2);
        }
        return fieldValue;
    }

    private static Field getDeclaredFieldPrivileged(final Class clazz, final String fieldName) {
        if (clazz == null || fieldName == null) {
            return null;
        }
        return (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class seekingClass = clazz;
                do {
                    try {
                        return seekingClass.getDeclaredField(fieldName);
                    }
                    catch (SecurityException ex) {
                        throw new NucleusException("CannotGetDeclaredField", ex).setFatal();
                    }
                    catch (NoSuchFieldException ex) {
                    }
                    catch (LinkageError ex) {
                        throw new NucleusException("ClassLoadingError", ex).setFatal();
                    }
                } while ((seekingClass = seekingClass.getSuperclass()) != null);
                return null;
            }
        });
    }

    private static Method getDeclaredMethodPrivileged(final Class clazz, final String methodName, final Class ... argTypes) {
        if (clazz == null || methodName == null) {
            return null;
        }
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class seekingClass = clazz;
                do {
                    try {
                        return seekingClass.getDeclaredMethod(methodName, argTypes);
                    }
                    catch (SecurityException ex) {
                        throw new NucleusException("Cannot get declared method " + methodName, ex).setFatal();
                    }
                    catch (NoSuchMethodException ex) {
                    }
                    catch (LinkageError ex) {
                        throw new NucleusException("ClassLoadingError", ex).setFatal();
                    }
                } while ((seekingClass = seekingClass.getSuperclass()) != null);
                return null;
            }
        });
    }

    public static Object getValueForIdentityField(Object id, String fieldName) {
        String getterName = ClassUtils.getJavaBeanGetterName(fieldName, false);
        try {
            return ClassUtils.getValueOfMethodByReflection(id, getterName, new Object[0]);
        }
        catch (NucleusException nucleusException) {
            try {
                return ClassUtils.getValueOfFieldByReflection(id, fieldName);
            }
            catch (NucleusException nucleusException2) {
                throw new NucleusUserException("Not possible to get value of field " + fieldName + " from identity " + id);
            }
        }
    }

    public static Class getClassForMemberOfClass(Class cls, String memberName) {
        Field fld = ClassUtils.getFieldForClass(cls, memberName);
        if (fld != null) {
            return fld.getType();
        }
        Method method = ClassUtils.getGetterMethodForClass(cls, memberName);
        if (method != null) {
            return method.getReturnType();
        }
        return null;
    }

    public static boolean isJavaBeanGetterMethod(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) {
            return false;
        }
        if (method.getName().startsWith("get") && method.getName().length() == 3) {
            return false;
        }
        if (method.getName().startsWith("is") && method.getName().length() == 2) {
            return false;
        }
        if (method.getReturnType() == null) {
            return false;
        }
        return method.getParameterTypes() == null || method.getParameterTypes().length == 0;
    }

    public static void clearFlags(boolean[] flags) {
        for (int i = 0; i < flags.length; ++i) {
            flags[i] = false;
        }
    }

    public static void clearFlags(boolean[] flags, int[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            flags[fields[i]] = false;
        }
    }

    public static int[] getFlagsSetTo(boolean[] flags, boolean state) {
        int[] temp = new int[flags.length];
        int j = 0;
        for (int i = 0; i < flags.length; ++i) {
            if (flags[i] != state) continue;
            temp[j++] = i;
        }
        if (j != 0) {
            int[] fieldNumbers = new int[j];
            System.arraycopy(temp, 0, fieldNumbers, 0, j);
            return fieldNumbers;
        }
        return null;
    }

    public static int[] getFlagsSetTo(boolean[] flags, int[] indices, boolean state) {
        if (indices == null) {
            return null;
        }
        int[] temp = new int[indices.length];
        int j = 0;
        for (int i = 0; i < indices.length; ++i) {
            if (flags[indices[i]] != state) continue;
            temp[j++] = indices[i];
        }
        if (j != 0) {
            int[] fieldNumbers = new int[j];
            System.arraycopy(temp, 0, fieldNumbers, 0, j);
            return fieldNumbers;
        }
        return null;
    }

    public static boolean getBitFromInt(int bits, int bitIndex) {
        if (bitIndex < 0 || bitIndex > 31) {
            throw new IllegalArgumentException();
        }
        return (bits & 1 << bitIndex) != 0;
    }

    public static int setBitInInt(int bits, int bitIndex, boolean flag) {
        if (bitIndex < 0 || bitIndex > 31) {
            throw new IllegalArgumentException();
        }
        int mask = 1 << bitIndex;
        return bits & ~mask | (flag ? mask : 0);
    }

    public static int[] getIndexesOfCollectionInList(List delegate, Collection elements) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int elemNum = 0;
        for (Object delegateElem : delegate) {
            for (Object elem : elements) {
                if (!elem.equals(delegateElem)) continue;
                indexes.add(elemNum);
                break;
            }
            ++elemNum;
        }
        return indexes.stream().sorted(Comparator.reverseOrder()).mapToInt(i -> i).toArray();
    }
}

