/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.histogram.kll;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.util.JavaDataModel;

public class KllUtils {
    private KllUtils() {
        throw new AssertionError((Object)"Suppress default constructor for non instantiation");
    }

    public static void serializeKll(OutputStream out, KllFloatsSketch kll) throws IOException {
        out.write(kll.toByteArray());
    }

    public static KllFloatsSketch deserializeKll(InputStream in) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4];
        while ((nRead = in.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])buffer.toByteArray()));
    }

    public static KllFloatsSketch deserializeKll(byte[] buf, int start, int len) {
        ByteArrayInputStream is = new ByteArrayInputStream(buf, start, len);
        try {
            KllFloatsSketch result = KllUtils.deserializeKll(is);
            ((InputStream)is).close();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static KllFloatsSketch deserializeKll(byte[] buf) {
        return KllUtils.deserializeKll(buf, 0, buf.length);
    }

    public static int lengthFor(JavaDataModel model, KllFloatsSketch kll) {
        return model == null ? KllFloatsSketch.getMaxSerializedSizeBytes((int)kll.getK(), (long)kll.getN(), (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)false) : (int)model.lengthForByteArrayOfSize((long)kll.getSerializedSizeBytes());
    }
}

