/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.thrift.TException;

public class JSONAlterTableMessage
extends AlterTableMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    String db;
    @JsonProperty
    String table;
    @JsonProperty
    String tableType;
    @JsonProperty
    String tableObjBeforeJson;
    @JsonProperty
    String tableObjAfterJson;
    @JsonProperty
    String isTruncateOp;
    @JsonProperty
    Long timestamp;
    @JsonProperty
    Long writeId;

    public JSONAlterTableMessage() {
    }

    public JSONAlterTableMessage(String server, String servicePrincipal, Table tableObjBefore, Table tableObjAfter, boolean isTruncateOp, Long writeId, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.db = tableObjBefore.getDbName();
        this.table = tableObjBefore.getTableName();
        this.tableType = tableObjBefore.getTableType();
        this.isTruncateOp = Boolean.toString(isTruncateOp);
        this.timestamp = timestamp;
        this.writeId = writeId;
        try {
            this.tableObjBeforeJson = MessageBuilder.createTableObjJson(tableObjBefore);
            this.tableObjAfterJson = MessageBuilder.createTableObjJson(tableObjAfter);
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
        this.checkValid();
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getTableType() {
        if (this.tableType != null) {
            return this.tableType;
        }
        return "";
    }

    @Override
    public boolean getIsTruncateOp() {
        return Boolean.parseBoolean(this.isTruncateOp);
    }

    @Override
    public Table getTableObjBefore() throws Exception {
        return (Table)MessageBuilder.getTObj(this.tableObjBeforeJson, Table.class);
    }

    @Override
    public Table getTableObjAfter() throws Exception {
        return (Table)MessageBuilder.getTObj(this.tableObjAfterJson, Table.class);
    }

    public String getTableObjBeforeJson() {
        return this.tableObjBeforeJson;
    }

    public String getTableObjAfterJson() {
        return this.tableObjAfterJson;
    }

    @Override
    public Long getWriteId() {
        return this.writeId == null ? 0L : this.writeId;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
    }
}

