/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.messaging.ReloadMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.thrift.TException;

public class JSONReloadMessage
extends ReloadMessage {
    @JsonProperty
    private Long timestamp;
    @JsonProperty
    private String server;
    @JsonProperty
    private String servicePrincipal;
    @JsonProperty
    private String db;
    @JsonProperty
    private String table;
    @JsonProperty
    private String tableObjJson;
    @JsonProperty
    private String ptnObjJson;
    @JsonProperty
    private String refreshEvent;

    public JSONReloadMessage() {
    }

    public JSONReloadMessage(String server, String servicePrincipal, Table tableObj, Partition ptnObj, boolean refreshEvent, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        if (null == tableObj) {
            throw new IllegalArgumentException("Table not valid.");
        }
        this.db = tableObj.getDbName();
        this.table = tableObj.getTableName();
        try {
            this.tableObjJson = MessageBuilder.createTableObjJson(tableObj);
            this.ptnObjJson = null != ptnObj ? MessageBuilder.createPartitionObjJson(ptnObj) : null;
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
        this.timestamp = timestamp;
        this.refreshEvent = Boolean.toString(refreshEvent);
        this.checkValid();
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean isRefreshEvent() {
        return Boolean.parseBoolean(this.refreshEvent);
    }

    @Override
    public Table getTableObj() throws Exception {
        return (Table)MessageBuilder.getTObj(this.tableObjJson, Table.class);
    }

    @Override
    public Partition getPtnObj() throws Exception {
        return null == this.ptnObjJson ? null : (Partition)MessageBuilder.getTObj(this.ptnObjJson, Partition.class);
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

