/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.leader.LeaderElection;
import org.apache.hadoop.hive.metastore.leader.LeaseLeaderElection;
import org.apache.hadoop.hive.metastore.metasummary.MetaSummaryHandler;
import org.apache.hadoop.hive.metastore.metasummary.MetaSummarySchema;
import org.apache.hadoop.hive.metastore.metasummary.MetadataTableSummary;
import org.apache.hadoop.hive.metastore.tools.MetaToolObjectStore;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTask;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaToolTaskMetadataSummary
extends MetaToolTask {
    private static final Logger LOG = LoggerFactory.getLogger(MetaToolTaskMetadataSummary.class);
    private static final Map<String, String> NON_NATIVE_SUMMARY_HANDLER = new HashMap<String, String>();
    boolean formatJson;
    boolean formatConsole;
    private long taskTimeout;
    private Integer recentUpdatedDays;
    private Integer maxNonNativeTables;
    private Configuration configuration;
    private static final TableName MUTEX;

    @Override
    void execute() {
        String[] inputParams = this.validateInput(this.getCl().getMetadataSummaryParams());
        if (inputParams == null) {
            return;
        }
        ExecutorService service = Executors.newSingleThreadExecutor();
        try (LeaseLeaderElection election = new LeaseLeaderElection();){
            election.setName("MetaSummaryTask");
            final AtomicBoolean acquiredLock = new AtomicBoolean(false);
            election.addStateListener(new LeaderElection.LeadershipStateListener(){

                @Override
                public void takeLeadership(LeaderElection election) throws Exception {
                    acquiredLock.set(true);
                }

                @Override
                public void lossLeadership(LeaderElection election) throws Exception {
                    acquiredLock.set(false);
                }
            });
            election.tryBeLeader(this.configuration, MUTEX);
            if (!acquiredLock.get()) {
                System.out.println("Another metadata summary task is running in the same warehouse, skipping this one...");
                this.showLocks();
                return;
            }
            Future<Pair> resFuture = service.submit(this::obtainAndFilterSummary);
            service.shutdown();
            Pair result = resFuture.get(this.taskTimeout, TimeUnit.MILLISECONDS);
            if (result == null) {
                System.err.println("Oops, no summary is generated...");
                return;
            }
            MetaSummarySchema extraSchema = (MetaSummarySchema)result.getLeft();
            List summaries = (List)result.getRight();
            String fileName = null;
            if (inputParams.length >= 2) {
                fileName = inputParams[1].toLowerCase().trim();
            }
            if (this.formatJson) {
                this.exportInJson(summaries, fileName == null ? "./MetastoreSummary.json" : fileName);
            } else if (this.formatConsole) {
                this.printToConsole(summaries, extraSchema);
            } else {
                this.exportInCsv(summaries, extraSchema, fileName == null ? "./MetastoreSummary.csv" : fileName);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            service.shutdownNow();
        }
    }

    String[] validateInput(String[] inputParams) {
        String val;
        String formatOption = inputParams[0].toLowerCase().trim();
        this.formatJson = formatOption.equalsIgnoreCase("-json");
        this.formatConsole = formatOption.equalsIgnoreCase("-console");
        boolean formatCsv = formatOption.equalsIgnoreCase("-csv");
        if (!(this.formatJson || formatCsv || this.formatConsole)) {
            System.err.println("Invalid format option: " + formatOption + " to -metadataSummary, only -json, -csv and -console are allowed");
            return null;
        }
        this.configuration = this.getObjectStore().getConf();
        this.recentUpdatedDays = inputParams.length >= 3 ? Integer.parseInt(inputParams[2]) : (int)MetastoreConf.getTimeVar((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METADATA_SUMMARY_RECENT_UPDATED, (TimeUnit)TimeUnit.DAYS);
        Integer n = this.maxNonNativeTables = inputParams.length >= 4 ? Integer.valueOf(Integer.parseInt(inputParams[3])) : null;
        if (this.maxNonNativeTables == null && !StringUtils.isEmpty((CharSequence)(val = MetastoreConf.getVar((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METADATA_SUMMARY_MAX_NONNATIVE_TABLES)))) {
            this.maxNonNativeTables = Integer.parseInt(val);
        }
        return inputParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<MetaSummarySchema, List<MetadataTableSummary>> obtainAndFilterSummary() throws MetaException {
        Deadline.registerIfNot(this.taskTimeout);
        boolean isTimerStarted = false;
        ExecutorService service = null;
        try {
            isTimerStarted = Deadline.startTimer("obtainAndFilterSummary");
            MetaToolObjectStore objectStore = this.getObjectStore();
            List<Object> allSummaries = objectStore.getMetadataSummary(null, null, null);
            if (allSummaries == null || allSummaries.isEmpty()) {
                System.out.println("Return set of tables is empty or null");
                Pair<MetaSummarySchema, List<MetadataTableSummary>> pair = null;
                return pair;
            }
            ArrayListMultimap<Class<? extends MetaSummaryHandler>, MetadataTableSummary> nonNativeSummaries = this.findNonNativeSummaries(allSummaries);
            HashSet<MetadataTableSummary> filteredSummary = new HashSet<MetadataTableSummary>();
            MetaSummarySchema extraSchema = new MetaSummarySchema();
            for (Class handler : nonNativeSummaries.keySet()) {
                Configuration conf = this.getObjectStore().getConf();
                ArrayList futures = new ArrayList();
                try {
                    MetaSummaryHandler summaryHandler = (MetaSummaryHandler)JavaUtils.newInstance((Class)handler);
                    try {
                        int nThreads;
                        summaryHandler.setConf(conf);
                        summaryHandler.initialize(MetaStoreUtils.getDefaultCatalog((Configuration)conf), this.formatJson, extraSchema);
                        List tableSummaries = nonNativeSummaries.get((Object)handler);
                        Set<Long> tableIds = this.getObjectStore().filterTablesForSummary(tableSummaries, this.recentUpdatedDays, this.maxNonNativeTables);
                        System.out.println("Filtered " + tableIds.size() + "/" + tableSummaries.size() + " " + ((MetadataTableSummary)tableSummaries.get(0)).getTableType() + " tables by recentUpdatedDays " + this.recentUpdatedDays + " and maxNonNativeTables " + this.maxNonNativeTables);
                        if (service == null && (nThreads = Math.min(MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METADATA_SUMMARY_NONNATIVE_THREADS), tableIds.size())) > 1) {
                            service = Executors.newFixedThreadPool(nThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("MetaToolTaskMetadataSummary #%d").build());
                        }
                        for (MetadataTableSummary metadataTableSummary : tableSummaries) {
                            if (!tableIds.contains(metadataTableSummary.getTableId())) {
                                filteredSummary.add(metadataTableSummary);
                                continue;
                            }
                            TableName tableName = new TableName(metadataTableSummary.getCatalogName(), metadataTableSummary.getDbName(), metadataTableSummary.getTblName());
                            Runnable task = () -> {
                                summaryHandler.appendSummary(tableName, summary);
                                if (summary.isDropped()) {
                                    filteredSummary.add(summary);
                                }
                            };
                            if (service != null) {
                                futures.add(service.submit(task));
                                continue;
                            }
                            task.run();
                        }
                        for (Future future : futures) {
                            future.get();
                        }
                    }
                    finally {
                        if (summaryHandler == null) continue;
                        summaryHandler.close();
                    }
                }
                catch (Exception e) {
                    System.err.println(ExceptionUtils.getStackTrace((Throwable)e));
                    LOG.warn("Error collecting the summary from handler: " + handler.getName(), (Throwable)e);
                }
            }
            System.out.println("Summary to be ignored: " + filteredSummary.size() + ", total summary: " + allSummaries.size());
            if (!filteredSummary.isEmpty()) {
                allSummaries = allSummaries.stream().filter(s -> !filteredSummary.contains(s)).collect(Collectors.toList());
            }
            Pair pair = Pair.of((Object)extraSchema, allSummaries);
            return pair;
        }
        finally {
            if (service != null) {
                service.shutdownNow();
            }
            if (isTimerStarted) {
                Deadline.stopTimer();
            }
        }
    }

    private ArrayListMultimap<Class<? extends MetaSummaryHandler>, MetadataTableSummary> findNonNativeSummaries(List<MetadataTableSummary> summaries) {
        ArrayListMultimap summaryHandlers = ArrayListMultimap.create();
        HashMap visitedClz = new HashMap();
        summaries.stream().filter(summary -> summary.getTableType() != null && NON_NATIVE_SUMMARY_HANDLER.containsKey(summary.getTableType().toLowerCase())).forEach(summary -> {
            String tableType = summary.getTableType().toLowerCase();
            String className = NON_NATIVE_SUMMARY_HANDLER.get(tableType);
            try {
                Class handler = (Class)visitedClz.get(className);
                if (handler == null) {
                    handler = JavaUtils.getClass((String)className, MetaSummaryHandler.class);
                    visitedClz.put(className, handler);
                }
                summaryHandlers.put((Object)handler, summary);
            }
            catch (Exception e) {
                TableName tableName = new TableName(summary.getCatalogName(), summary.getDbName(), summary.getTblName());
                LOG.error("Unable to load the class: " + className + ", will ignore the non-native summary for the table: " + tableName, (Throwable)e);
            }
        });
        return summaryHandlers;
    }

    public void exportInJson(List<MetadataTableSummary> tableSummaryList, String filename) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonElement element = gson.toJsonTree(tableSummaryList);
        if (element.isJsonArray()) {
            JsonArray elements = element.getAsJsonArray();
            for (JsonElement outer : elements) {
                JsonObject object;
                JsonElement innerElement;
                if (!outer.isJsonObject() || (innerElement = (object = outer.getAsJsonObject()).get("summary")) == null || !innerElement.isJsonObject()) continue;
                JsonObject innerObject = innerElement.getAsJsonObject();
                for (String fieldName : innerObject.keySet().toArray(new String[0])) {
                    object.add(fieldName, innerObject.remove(fieldName));
                }
                object.remove("summary");
            }
        }
        this.writeJsonInFile(gson.toJson(element), filename);
    }

    public void printToConsole(List<MetadataTableSummary> tableSummariesList, MetaSummarySchema extraSchema) {
        System.out.println("----    ----    ----    ----    ----    ----    ----    ----    ----    ----    ----    ----    ----   LEGEND -----    ----    ----    ----    ---    -----     ----    ----    ----    -----");
        System.out.print("\u001b[0;1m#COLS\u001b[0m ");
        System.out.print("--> # of columns in the table ");
        System.out.print("\u001b[0;1m#PARTS\u001b[0m ");
        System.out.print("--> # of Partitions ");
        System.out.print("\u001b[0;1m#ROWS\u001b[0m ");
        System.out.print("--> # of rows in table ");
        System.out.print("\u001b[0;1m#FILES\u001b[0m ");
        System.out.print("--> No of files in table ");
        System.out.print("\u001b[0;1mSIZE\u001b[0m ");
        System.out.print("--> Size of table in bytes ");
        System.out.print("\u001b[0;1m#PCOLS\u001b[0m ");
        System.out.print("--> # of partition columns ");
        System.out.print("\u001b[0;1m#ARR\u001b[0m ");
        System.out.print("--> # of array columns ");
        System.out.print("\u001b[0;1m#STRT\u001b[0m ");
        System.out.print("--> # of struct columns ");
        System.out.print("\u001b[0;1m#MAP\u001b[0m ");
        System.out.print("--> # of map columns ");
        StringBuilder format = new StringBuilder("");
        List extraFields = extraSchema.getFields();
        ArrayList<String> upperFields = new ArrayList<String>(extraFields.size());
        ArrayList<String> columns = new ArrayList<String>(Arrays.asList("DATABASE", "TABLE NAME", "OWNER", "#COLS", "#PARTS", "TYPE", "FORMAT", "COMPRESSION", "#ROWS", "#FILES", "SIZE(b)", "#PCOLS", "#ARR", "#STRT", "#MAP"));
        int colIndex = columns.size() + 1;
        for (String field : extraFields) {
            String upperField = field.toUpperCase();
            System.out.print("\u001b[0;1m#" + upperField + "\u001b[0m ");
            System.out.print("--> # extra summary field ");
            upperFields.add(upperField);
            format.append(" %").append(colIndex++).append("$15s ");
        }
        System.out.println("");
        System.out.println("-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
        System.out.println("                                                                                                    Metadata Summary                                                                                                        ");
        System.out.println("-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
        System.out.print("\u001b[0;1m");
        columns.addAll(upperFields);
        System.out.printf("%1$20s %2$30s %3$10s %4$5s %5$5s %6$15s %7$15s %8$10s %9$10s %10$10s %11$10s %12$10s %13$5s %14$5s %15$5s" + format, columns.toArray());
        System.out.print("\u001b[0m");
        System.out.println();
        System.out.println("------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
        Object[] values = new String[extraSchema.size()];
        Arrays.fill(values, "-");
        for (MetadataTableSummary summary : tableSummariesList) {
            Map extraSummary = summary.getExtraSummary();
            if (extraSummary != null) {
                for (int i = 0; i < extraSchema.size(); ++i) {
                    Object val = extraSummary.get(extraFields.get(i));
                    if (val == null) continue;
                    values[i] = String.valueOf(val);
                }
            }
            ArrayList<Serializable> vals = new ArrayList<Serializable>(Arrays.asList(summary.getDbName(), summary.getTblName(), summary.getOwner(), summary.getColCount(), summary.getPartitionCount(), summary.getTableType(), summary.getFileFormat(), summary.getCompressionType(), summary.getNumRows(), summary.getNumFiles(), summary.getTotalSize(), summary.getPartitionColumnCount(), summary.getArrayColumnCount(), summary.getStructColumnCount(), summary.getMapColumnCount()));
            vals.addAll(Arrays.asList(values));
            System.out.format("%1$20s %2$30s %3$10s %4$5d %5$5d %6$15s %7$15s %8$10s %9$10s %10$10s %11$10s %12$10s %13$5d %14$5d %15$5d" + format, vals.toArray());
            System.out.println();
            Arrays.fill(values, "-");
        }
        System.out.println("------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
    }

    public void exportInCsv(List<MetadataTableSummary> metadataTableSummaryList, MetaSummarySchema extraSchema, String filename) throws IOException {
        File csvOutputFile = new File(filename);
        try (PrintWriter pw = new PrintWriter(csvOutputFile);){
            StringBuilder header = new StringBuilder().append("Database Name, Table Name, Owner, Column Count, Partition Count, Table Type, File Format,").append("Compression Type, Number of Rows, Number of Files, Size in Bytes, Partition Column Count, Array Column Count, Struct Column Count, Map Column Count");
            List fields = extraSchema.getFields();
            if (!fields.isEmpty()) {
                header.append(", ").append(String.join((CharSequence)", ", fields));
            }
            pw.println(header);
            metadataTableSummaryList.stream().map(summary -> summary.toCSV(fields)).forEach(pw::println);
            pw.flush();
        }
        catch (IOException e) {
            System.out.println("IOException occurred: " + e);
            throw e;
        }
    }

    private void writeJsonInFile(String jsonOutput, String filename) throws IOException {
        File jsonOutputFile;
        try {
            jsonOutputFile = new File(filename);
            if (jsonOutputFile.exists()) {
                File oldFile = new File(jsonOutputFile.getAbsolutePath() + "_old");
                System.out.println("Output file already exists, renaming to " + oldFile);
                jsonOutputFile.renameTo(oldFile);
            }
            if (jsonOutputFile.createNewFile()) {
                System.out.println("File created: " + jsonOutputFile.getName());
            } else {
                System.out.println("File already exists.");
            }
        }
        catch (IOException e) {
            System.out.println("IOException occurred: " + e);
            throw e;
        }
        try (PrintWriter pw = new PrintWriter(jsonOutputFile);){
            pw.println(jsonOutput);
            pw.flush();
            System.out.println("Summary written to " + jsonOutputFile);
        }
        catch (IOException ex) {
            System.out.println("Failed to write output file:" + ex.getMessage());
            throw ex;
        }
    }

    @VisibleForTesting
    public static void addSummaryHandler(String tableType, String handlerName) throws ClassNotFoundException {
        if (tableType == null || handlerName == null) {
            throw new IllegalArgumentException("The input parameters shouldn't be null");
        }
        Class.forName(handlerName);
        NON_NATIVE_SUMMARY_HANDLER.put(tableType, handlerName);
    }

    @Override
    void setObjectStore(MetaToolObjectStore objectStore) {
        super.setObjectStore(objectStore);
        this.taskTimeout = MetastoreConf.getTimeVar((Configuration)objectStore.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METADATA_SUMMARY_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void showLocks() throws Exception {
        ShowLocksRequest request = new ShowLocksRequest();
        request.setDbname(MUTEX.getDb());
        request.setTablename(MUTEX.getTable());
        ShowLocksResponse response = TxnUtils.getTxnStore(this.configuration).showLocks(request);
        if (response.getLocks() != null) {
            System.out.println("The host which holds the mutex is running the metadata summary task");
            response.getLocks().forEach(lock -> {
                StringBuilder builder = new StringBuilder("Mutex: ").append(MUTEX).append(", host: ").append(lock.getHostname()).append(", agent: ").append(lock.getAgentInfo()).append(", state: ").append(lock.getState()).append(", user: ").append(lock.getUser()).append(", acquired at: ").append(lock.getAcquiredat());
                System.out.println(builder.toString());
            });
        }
    }

    static {
        NON_NATIVE_SUMMARY_HANDLER.put("iceberg", "org.apache.iceberg.metasummary.IcebergSummaryHandler");
        MUTEX = new TableName("__METATOOL__", "__METATOOL_METADATA_SUMMARY__TASK__", "__metadata__summary__task__");
    }
}

