/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class HeartbeatLockFunction
implements TransactionalFunction<Void> {
    private final long extLockId;

    public HeartbeatLockFunction(long extLockId) {
        this.extLockId = extLockId;
    }

    @Override
    public Void execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException, NoSuchTxnException, TxnAbortedException, NoSuchLockException {
        if (this.extLockId == 0L) {
            return null;
        }
        int rc = jdbcResource.getJdbcTemplate().update("UPDATE \"HIVE_LOCKS\" SET \"HL_LAST_HEARTBEAT\" = " + TxnUtils.getEpochFn(jdbcResource.getDatabaseProduct()) + " WHERE \"HL_LOCK_EXT_ID\" = :extLockId", (SqlParameterSource)new MapSqlParameterSource().addValue("extLockId", (Object)this.extLockId));
        if (rc < 1) {
            throw new NoSuchLockException("No such lock: " + JavaUtils.lockIdToString((long)this.extLockId));
        }
        jdbcResource.getTransactionManager().getActiveTransaction().createSavepoint();
        return null;
    }
}

