/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class GetHighWaterMarkHandler
implements QueryHandler<Long> {
    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return "SELECT MAX(\"TXN_ID\") FROM \"TXNS\"";
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource();
    }

    public Long extractData(ResultSet rs) throws SQLException, DataAccessException {
        if (rs.next()) {
            long max = rs.getLong(1);
            if (rs.wasNull()) {
                throw new EmptyResultDataAccessException("Transaction tables not properly initialized, null record found in MAX(TXN_ID)", 1);
            }
            return max;
        }
        throw new EmptyResultDataAccessException("Transaction tables not properly initialized, null record found in MAX(TXN_ID)", 1);
    }
}

