/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hop.workflow.actions.sftp;

import java.util.Arrays;
import java.util.List;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironmentExtension;
import org.apache.hop.workflow.action.loadsave.WorkflowActionLoadSaveTestSupport;
import org.junit.jupiter.api.extension.RegisterExtension;

class WorkflowActionSftpLoadSaveTest extends WorkflowActionLoadSaveTestSupport<ActionSftp> {
  @RegisterExtension
  static RestoreHopEngineEnvironmentExtension env = new RestoreHopEngineEnvironmentExtension();

  @Override
  protected Class<ActionSftp> getActionClass() {
    return ActionSftp.class;
  }

  @Override
  protected List<String> listAttributes() {
    return Arrays.asList(
        "serverName",
        "serverPort",
        "userName",
        "password",
        "scpDirectory",
        "targetDirectory",
        "wildcard",
        "remove",
        "addToResult",
        "createTargetFolder",
        "copyPrevious",
        "useKeyFile",
        "keyFilename",
        "keyPassPhrase",
        "compression",
        "proxyType",
        "proxyHost",
        "proxyPort",
        "proxyUsername",
        "proxyPassword");
  }
}
