/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import org.apache.hc.client5.http.cache.ResponseCacheControl;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.MessageSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResponseCachingPolicy {
    private static final Duration DEFAULT_FRESHNESS_DURATION = Duration.ofMinutes(5L);
    private static final Logger LOG = LoggerFactory.getLogger(ResponseCachingPolicy.class);
    private final boolean sharedCache;
    private final boolean neverCache1_0ResponsesWithQueryString;
    private final boolean neverCache1_1ResponsesWithQueryString;

    public ResponseCachingPolicy(boolean sharedCache, boolean neverCache1_0ResponsesWithQueryString, boolean neverCache1_1ResponsesWithQueryString) {
        this.sharedCache = sharedCache;
        this.neverCache1_0ResponsesWithQueryString = neverCache1_0ResponsesWithQueryString;
        this.neverCache1_1ResponsesWithQueryString = neverCache1_1ResponsesWithQueryString;
    }

    public boolean isResponseCacheable(ResponseCacheControl cacheControl, HttpRequest request, HttpResponse response) {
        Instant responseExpires;
        HttpVersion version;
        Object object = version = request.getVersion() != null ? request.getVersion() : HttpVersion.DEFAULT;
        if (version.compareToVersion((ProtocolVersion)HttpVersion.HTTP_1_1) > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Protocol version {} is non-cacheable", (Object)version);
            }
            return false;
        }
        String httpMethod = request.getMethod();
        if (!Method.GET.isSame(httpMethod) && !Method.HEAD.isSame(httpMethod)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} method response is not cacheable", (Object)httpMethod);
            }
            return false;
        }
        int code = response.getCode();
        if (code <= 100) {
            return false;
        }
        if (ResponseCachingPolicy.isKnownNonCacheableStatusCode(code)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} response is not cacheable", (Object)code);
            }
            return false;
        }
        if (request.getPath().contains("?")) {
            if (this.neverCache1_0ResponsesWithQueryString && this.from1_0Origin(response)) {
                LOG.debug("Response is not cacheable as it had a query string");
                return false;
            }
            if (!this.neverCache1_1ResponsesWithQueryString && !this.isExplicitlyCacheable(cacheControl, response)) {
                LOG.debug("Response is not cacheable as it is missing explicit caching headers");
                return false;
            }
        }
        if (cacheControl.isMustUnderstand() && !this.understoodStatusCode(code)) {
            LOG.debug("Response contains a status code that the cache does not understand, so it's not cacheable");
            return false;
        }
        if (this.isExplicitlyNonCacheable(cacheControl)) {
            LOG.debug("Response is explicitly non-cacheable per cache control directive");
            return false;
        }
        if (this.sharedCache && request.containsHeader("Authorization") && cacheControl.getSharedMaxAge() == -1L && !cacheControl.isPublic()) {
            LOG.debug("Request contains private credentials");
            return false;
        }
        if (response.countHeaders("Expires") > 1) {
            LOG.debug("Multiple Expires headers");
            return false;
        }
        if (response.countHeaders("Date") > 1) {
            LOG.debug("Multiple Date headers");
            return false;
        }
        Instant responseDate = DateUtils.parseStandardDate((MessageHeaders)response, (String)"Date");
        if (this.expiresHeaderLessOrEqualToDateHeaderAndNoCacheControl(cacheControl, responseDate, responseExpires = DateUtils.parseStandardDate((MessageHeaders)response, (String)"Expires"))) {
            LOG.debug("Expires header less or equal to Date header and no cache control directives");
            return false;
        }
        Iterator it = MessageSupport.iterateTokens((MessageHeaders)response, (String)"Vary");
        while (it.hasNext()) {
            String token = (String)it.next();
            if (!"*".equals(token)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Vary: * found");
            }
            return false;
        }
        return this.isExplicitlyCacheable(cacheControl, response) || this.isHeuristicallyCacheable(cacheControl, code, responseDate, responseExpires);
    }

    private static boolean isKnownCacheableStatusCode(int status) {
        return status == 200 || status == 203 || status == 300 || status == 301 || status == 410;
    }

    private static boolean isKnownNonCacheableStatusCode(int status) {
        return status == 206;
    }

    private static boolean isUnknownStatusCode(int status) {
        if (status >= 100 && status <= 101) {
            return false;
        }
        if (status >= 200 && status <= 206) {
            return false;
        }
        if (status >= 300 && status <= 307) {
            return false;
        }
        if (status >= 400 && status <= 417) {
            return false;
        }
        return status < 500 || status > 505;
    }

    protected boolean isExplicitlyNonCacheable(ResponseCacheControl cacheControl) {
        if (cacheControl == null) {
            return false;
        }
        return cacheControl.isNoStore() || this.sharedCache && cacheControl.isCachePrivate();
    }

    protected boolean isExplicitlyCacheable(ResponseCacheControl cacheControl, HttpResponse response) {
        if (cacheControl.isPublic()) {
            return true;
        }
        if (!this.sharedCache && cacheControl.isCachePrivate()) {
            return true;
        }
        if (response.containsHeader("Expires")) {
            return true;
        }
        if (cacheControl.getMaxAge() > 0L) {
            return true;
        }
        return this.sharedCache && cacheControl.getSharedMaxAge() > 0L;
    }

    protected boolean isHeuristicallyCacheable(ResponseCacheControl cacheControl, int status, Instant responseDate, Instant responseExpires) {
        if (ResponseCachingPolicy.isKnownCacheableStatusCode(status)) {
            Duration freshnessLifetime = this.calculateFreshnessLifetime(cacheControl, responseDate, responseExpires);
            if (freshnessLifetime.isNegative()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Freshness lifetime is invalid");
                }
                return false;
            }
            if (cacheControl.isImmutable() && this.responseIsStillFresh(responseDate, freshnessLifetime)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response is immutable and fresh, considered cacheable without further validation");
                }
                return true;
            }
            if (freshnessLifetime.compareTo(Duration.ZERO) > 0) {
                return true;
            }
        } else if (ResponseCachingPolicy.isUnknownStatusCode(status)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} response is unknown", (Object)status);
            }
            return false;
        }
        return false;
    }

    private boolean expiresHeaderLessOrEqualToDateHeaderAndNoCacheControl(ResponseCacheControl cacheControl, Instant responseDate, Instant expires) {
        if (!cacheControl.isUndefined()) {
            return false;
        }
        if (expires == null || responseDate == null) {
            return false;
        }
        return expires.compareTo(responseDate) <= 0;
    }

    private boolean from1_0Origin(HttpResponse response) {
        Iterator it = MessageSupport.iterateTokens((MessageHeaders)response, (String)"Via");
        if (it.hasNext()) {
            String token = (String)it.next();
            return token.startsWith("1.0 ") || token.startsWith("HTTP/1.0 ");
        }
        HttpVersion version = response.getVersion() != null ? response.getVersion() : HttpVersion.DEFAULT;
        return HttpVersion.HTTP_1_0.equals((Object)version);
    }

    private Duration calculateFreshnessLifetime(ResponseCacheControl cacheControl, Instant responseDate, Instant responseExpires) {
        if (cacheControl.isUndefined()) {
            return DEFAULT_FRESHNESS_DURATION;
        }
        if (cacheControl.getSharedMaxAge() != -1L) {
            return Duration.ofSeconds(cacheControl.getSharedMaxAge());
        }
        if (cacheControl.getMaxAge() != -1L) {
            return Duration.ofSeconds(cacheControl.getMaxAge());
        }
        if (responseDate != null && responseExpires != null) {
            return Duration.ofSeconds(responseExpires.getEpochSecond() - responseDate.getEpochSecond());
        }
        return DEFAULT_FRESHNESS_DURATION;
    }

    private boolean understoodStatusCode(int status) {
        return status >= 200 && status <= 206 || status >= 300 && status <= 399 || status >= 400 && status <= 417 || status == 421 || status >= 500 && status <= 505;
    }

    private boolean responseIsStillFresh(Instant responseDate, Duration freshnessLifetime) {
        if (responseDate == null) {
            return false;
        }
        Duration age = Duration.between(responseDate, Instant.now());
        return age.compareTo(freshnessLifetime) < 0;
    }
}

