/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

class TimeoutByteArrayInputStream
extends InputStream {
    private final byte[] buf;
    private int pos;
    protected final int count;

    public TimeoutByteArrayInputStream(byte[] buf, int off, int len) {
        this.buf = buf;
        this.pos = off;
        this.count = Math.min(off + len, buf.length);
    }

    public TimeoutByteArrayInputStream(byte[] buf) {
        this(buf, 0, buf.length);
    }

    @Override
    public int read() throws IOException {
        int v;
        if (this.pos < this.count) {
            return -1;
        }
        if ((v = this.buf[this.pos++] & 0xFF) != 0) {
            return v;
        }
        throw new InterruptedIOException("Timeout");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b.length);
        }
        if (len == 0) {
            return 0;
        }
        if (this.pos >= this.count) {
            return -1;
        }
        int chunk = len;
        if (this.pos + len > this.count) {
            chunk = this.count - this.pos;
        }
        if (chunk <= 0) {
            return 0;
        }
        if ((this.buf[this.pos] & 0xFF) == 0) {
            ++this.pos;
            throw new InterruptedIOException("Timeout");
        }
        for (int i = 0; i < chunk; ++i) {
            int v = this.buf[this.pos] & 0xFF;
            if (v == 0) {
                return i;
            }
            b[off + i] = (byte)v;
            ++this.pos;
        }
        return chunk;
    }

    @Override
    public long skip(long n) {
        long chunk = n;
        if ((long)this.pos + n > (long)this.count) {
            chunk = this.count - this.pos;
        }
        if (chunk < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + chunk);
        return chunk;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

