/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.ProtocolVersionParser;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.Tokenizer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestProtocolVersionParser {
    private ProtocolVersionParser impl;

    TestProtocolVersionParser() {
    }

    @BeforeEach
    void setup() {
        this.impl = new ProtocolVersionParser();
    }

    public ProtocolVersion parseStr(String protocol, String s) throws ParseException {
        return this.impl.parse(protocol, null, (CharSequence)s, (Tokenizer.Cursor)new ParserCursor(0, s.length()), null);
    }

    public ProtocolVersion parseStr(String protocol, String s, Tokenizer.Delimiter delimiterPredicate) throws ParseException {
        return this.impl.parse(protocol, null, (CharSequence)s, (Tokenizer.Cursor)new ParserCursor(0, s.length()), delimiterPredicate);
    }

    public ProtocolVersion parseStr(String protocol, String s, Tokenizer.Cursor cursor, Tokenizer.Delimiter delimiterPredicate) throws ParseException {
        return this.impl.parse(protocol, null, (CharSequence)s, cursor, delimiterPredicate);
    }

    public ProtocolVersion parseStr(String s) throws ParseException {
        return this.impl.parse((CharSequence)s, (Tokenizer.Cursor)new ParserCursor(0, s.length()), null);
    }

    public ProtocolVersion parseStr(String s, Tokenizer.Delimiter delimiterPredicate) throws ParseException {
        return this.impl.parse((CharSequence)s, (Tokenizer.Cursor)new ParserCursor(0, s.length()), delimiterPredicate);
    }

    @Test
    void testParseVersion() throws Exception {
        Assertions.assertEquals((Object)new ProtocolVersion("PROTO", 1, 0), (Object)this.parseStr("PROTO", "1  "));
        Assertions.assertEquals((Object)new ProtocolVersion("PROTO", 1, 1), (Object)this.parseStr("PROTO", "1.1   "));
        Assertions.assertEquals((Object)new ProtocolVersion("PROTO", 1, 20), (Object)this.parseStr("PROTO", "1.020  "));
        Assertions.assertEquals((Object)new ProtocolVersion("PROTO", 22, 356), (Object)this.parseStr("PROTO", "22.356  "));
        Assertions.assertEquals((Object)new ProtocolVersion("PROTO", 1, 0), (Object)this.parseStr("PROTO", "1,  ", Tokenizer.delimiters((char)',')));
        Assertions.assertEquals((Object)new ProtocolVersion("PROTO", 1, 1), (Object)this.parseStr("PROTO", "1.1;   ", Tokenizer.delimiters((char)',', (char)';')));
        Assertions.assertEquals((Object)new ProtocolVersion("PROTO", 1, 200), (Object)this.parseStr("PROTO", "1.200 blah; ", Tokenizer.delimiters((char)',')));
    }

    @Test
    void testParseVersionWithCursor() throws Exception {
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(2, 13);
        Assertions.assertEquals((Object)new ProtocolVersion("PROTO", 1, 20), (Object)this.parseStr("PROTO", "  1.20,0000,00000", cursor, Tokenizer.delimiters((char)',')));
        MatcherAssert.assertThat((Object)cursor.getPos(), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    void testParseProtocolVersion() throws Exception {
        Assertions.assertEquals((Object)new ProtocolVersion("PROTO", 1, 0), (Object)this.parseStr("PROTO/1  "));
        Assertions.assertEquals((Object)new ProtocolVersion("PROTO", 1, 1), (Object)this.parseStr("PROTO/1.1   "));
        Assertions.assertEquals((Object)new ProtocolVersion("PROTO", 1, 20), (Object)this.parseStr("PROTO/1.020  "));
        Assertions.assertEquals((Object)new ProtocolVersion("PROTO", 22, 356), (Object)this.parseStr("PROTO/22.356  "));
        Assertions.assertEquals((Object)new ProtocolVersion("PROTO", 1, 0), (Object)this.parseStr("PROTO/1,  ", Tokenizer.delimiters((char)',')));
        Assertions.assertEquals((Object)new ProtocolVersion("PROTO", 1, 1), (Object)this.parseStr("PROTO/1.1;   ", Tokenizer.delimiters((char)',', (char)';')));
        Assertions.assertEquals((Object)new ProtocolVersion("PROTO", 1, 200), (Object)this.parseStr("PROTO/1.200 blah; ", Tokenizer.delimiters((char)',')));
    }

    @Test
    void testParseFailures() {
        Assertions.assertThrows(ParseException.class, () -> this.parseStr("PROTO", "blah"));
        Assertions.assertThrows(ParseException.class, () -> this.parseStr("PROTO", "1.blah"));
        Assertions.assertThrows(ParseException.class, () -> this.parseStr("PROTO", "1A.0"));
        Assertions.assertThrows(ParseException.class, () -> this.parseStr("PROTO", ""));
        Assertions.assertThrows(ParseException.class, () -> this.parseStr(""));
        Assertions.assertThrows(ParseException.class, () -> this.parseStr("   "));
        Assertions.assertThrows(ParseException.class, () -> this.parseStr("   /1.0"));
        Assertions.assertThrows(ParseException.class, () -> this.parseStr("   / "));
        Assertions.assertThrows(ParseException.class, () -> this.parseStr("PROTO"));
        Assertions.assertThrows(ParseException.class, () -> this.parseStr("PROTO/"));
        Assertions.assertThrows(ParseException.class, () -> this.parseStr("PROTO/ 1.0"));
    }
}

