/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.hc.core5.http.StreamClosedException;
import org.apache.hc.core5.http.impl.io.ContentLengthOutputStream;
import org.apache.hc.core5.http.impl.io.SessionOutputBufferImpl;
import org.apache.hc.core5.http.io.SessionOutputBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestContentLengthOutputStream {
    TestContentLengthOutputStream() {
    }

    @Test
    void testBasics() throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        try (ContentLengthOutputStream out = new ContentLengthOutputStream((SessionOutputBuffer)outbuffer, (OutputStream)outputStream, 15L);){
            byte[] tmp = new byte[10];
            out.write(tmp, 0, 10);
            out.write(1);
            out.write(tmp, 0, 10);
            out.write(tmp, 0, 10);
            out.write(tmp);
            out.write(1);
            out.write(2);
            out.flush();
        }
        byte[] data = outputStream.toByteArray();
        Assertions.assertEquals((int)15, (int)data.length);
    }

    @Test
    void testClose() throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SessionOutputBufferImpl outbuffer = new SessionOutputBufferImpl(16);
        ContentLengthOutputStream out = new ContentLengthOutputStream((SessionOutputBuffer)outbuffer, (OutputStream)outputStream, 15L);
        out.close();
        out.close();
        byte[] tmp = new byte[10];
        Assertions.assertThrows(StreamClosedException.class, () -> TestContentLengthOutputStream.lambda$testClose$0((OutputStream)out, tmp));
        Assertions.assertThrows(StreamClosedException.class, () -> TestContentLengthOutputStream.lambda$testClose$1((OutputStream)out));
    }

    private static /* synthetic */ void lambda$testClose$1(OutputStream out) throws Throwable {
        out.write(1);
    }

    private static /* synthetic */ void lambda$testClose$0(OutputStream out, byte[] tmp) throws Throwable {
        out.write(tmp);
    }
}

