/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.InputStream;
import java.util.List;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseFactory;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.MethodNotSupportedException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.UnsupportedHttpVersionException;
import org.apache.hc.core5.http.impl.io.HttpService;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.HttpServerConnection;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

class TestHttpService {
    @Mock
    private HttpProcessor httprocessor;
    @Mock
    private ConnectionReuseStrategy connReuseStrategy;
    @Spy
    private final ClassicHttpResponse response = new BasicClassicHttpResponse(200);
    @Mock
    private HttpResponseFactory<ClassicHttpResponse> responseFactory;
    @Mock
    private HttpRequestMapper<HttpRequestHandler> handlerResolver;
    @Mock
    private HttpRequestHandler requestHandler;
    @Mock
    private HttpServerConnection conn;
    private HttpService httpservice;

    TestHttpService() {
    }

    @BeforeEach
    void prepareMocks() {
        MockitoAnnotations.openMocks((Object)this);
        this.httpservice = new HttpService(this.httprocessor, this.handlerResolver, this.connReuseStrategy, this.responseFactory);
    }

    @Test
    void testInvalidInitialization() {
        Assertions.assertThrows(NullPointerException.class, () -> new HttpService(null, this.handlerResolver, this.connReuseStrategy, this.responseFactory));
    }

    @Test
    void testBasicExecution() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        Mockito.when((Object)this.conn.receiveRequestHeader()).thenReturn((Object)request);
        Mockito.when((Object)this.responseFactory.newHttpResponse(200)).thenReturn((Object)this.response);
        Mockito.when((Object)this.connReuseStrategy.keepAlive((HttpRequest)request, (HttpResponse)this.response, (HttpContext)context)).thenReturn((Object)Boolean.FALSE);
        this.httpservice.handleRequest(this.conn, (HttpContext)context);
        Assertions.assertEquals((int)501, (int)this.response.getCode());
        Assertions.assertSame((Object)request, (Object)context.getRequest());
        Assertions.assertSame((Object)this.response, (Object)context.getResponse());
        ((HttpProcessor)Mockito.verify((Object)this.httprocessor)).process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)this.httprocessor)).process((HttpResponse)this.response, (EntityDetails)this.response.getEntity(), (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseHeader(this.response);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseEntity(this.response);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).flush();
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).close();
        ((ClassicHttpResponse)Mockito.verify((Object)this.response)).close();
    }

    @Test
    void testExecutionEntityEnclosingRequest() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        InputStreamEntity entity = new InputStreamEntity(inStream, -1L, null);
        request.setEntity((HttpEntity)entity);
        Mockito.when((Object)this.conn.receiveRequestHeader()).thenReturn((Object)request);
        Mockito.when((Object)this.responseFactory.newHttpResponse(200)).thenReturn((Object)this.response);
        Mockito.when((Object)this.connReuseStrategy.keepAlive((HttpRequest)ArgumentMatchers.eq((Object)request), (HttpResponse)ArgumentMatchers.argThat(errorResponse -> errorResponse.getCode() == 501), (HttpContext)ArgumentMatchers.eq((Object)context))).thenReturn((Object)Boolean.TRUE);
        this.httpservice.handleRequest(this.conn, (HttpContext)context);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(ClassicHttpResponse.class);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseHeader((ClassicHttpResponse)responseCaptor.capture());
        ClassicHttpResponse response = (ClassicHttpResponse)responseCaptor.getValue();
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((int)501, (int)response.getCode());
        Assertions.assertSame((Object)request, (Object)context.getRequest());
        ((HttpProcessor)Mockito.verify((Object)this.httprocessor)).process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        ((InputStream)Mockito.verify((Object)inStream)).close();
        ((HttpProcessor)Mockito.verify((Object)this.httprocessor)).process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseHeader(response);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseEntity(response);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).flush();
        ((HttpServerConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.never())).close();
        ((ClassicHttpResponse)Mockito.verify((Object)response)).close();
    }

    @Test
    void testExecutionEntityEnclosingRequestWithExpectContinue() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.addHeader("Expect", (Object)"100-continue");
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        InputStreamEntity entity = new InputStreamEntity(inStream, -1L, null);
        request.setEntity((HttpEntity)entity);
        Mockito.when((Object)this.conn.receiveRequestHeader()).thenReturn((Object)request);
        Mockito.when((Object)this.responseFactory.newHttpResponse(200)).thenReturn((Object)this.response);
        Mockito.when((Object)this.connReuseStrategy.keepAlive((HttpRequest)ArgumentMatchers.eq((Object)request), (HttpResponse)ArgumentMatchers.argThat(errorResponse -> errorResponse.getCode() == 501), (HttpContext)ArgumentMatchers.eq((Object)context))).thenReturn((Object)Boolean.TRUE);
        this.httpservice.handleRequest(this.conn, (HttpContext)context);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(ClassicHttpResponse.class);
        ((HttpServerConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).sendResponseHeader((ClassicHttpResponse)responseCaptor.capture());
        List responses = responseCaptor.getAllValues();
        Assertions.assertNotNull((Object)responses);
        Assertions.assertEquals((int)2, (int)responses.size());
        ClassicHttpResponse ack = (ClassicHttpResponse)responses.get(0);
        ClassicHttpResponse response = (ClassicHttpResponse)responses.get(1);
        Assertions.assertEquals((int)100, (int)ack.getCode());
        Assertions.assertEquals((int)501, (int)response.getCode());
        Assertions.assertSame((Object)request, (Object)context.getRequest());
        ((HttpProcessor)Mockito.verify((Object)this.httprocessor)).process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        ((InputStream)Mockito.verify((Object)inStream)).close();
        ((HttpProcessor)Mockito.verify((Object)this.httprocessor)).process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseHeader(response);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseEntity(response);
        ((HttpServerConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).flush();
        ((HttpServerConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.never())).close();
        ((ClassicHttpResponse)Mockito.verify((Object)response)).close();
    }

    @Test
    void testMethodNotSupported() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("whatever", "/");
        Mockito.when((Object)this.conn.receiveRequestHeader()).thenReturn((Object)request);
        Mockito.when((Object)this.responseFactory.newHttpResponse(200)).thenReturn((Object)this.response);
        Mockito.when((Object)this.handlerResolver.resolve((HttpRequest)request, (HttpContext)context)).thenReturn((Object)this.requestHandler);
        ((HttpRequestHandler)Mockito.doThrow((Throwable[])new Throwable[]{new MethodNotSupportedException("whatever")}).when((Object)this.requestHandler)).handle((ClassicHttpRequest)request, this.response, (HttpContext)context);
        this.httpservice.handleRequest(this.conn, (HttpContext)context);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(ClassicHttpResponse.class);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseHeader((ClassicHttpResponse)responseCaptor.capture());
        ClassicHttpResponse error = (ClassicHttpResponse)responseCaptor.getValue();
        Assertions.assertNotNull((Object)error);
        Assertions.assertSame((Object)request, (Object)context.getRequest());
        Assertions.assertEquals((int)501, (int)error.getCode());
        ((HttpProcessor)Mockito.verify((Object)this.httprocessor)).process((HttpResponse)error, (EntityDetails)error.getEntity(), (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseHeader(error);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseEntity(error);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).close();
    }

    @Test
    void testUnsupportedHttpVersionException() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("whatever", "/");
        Mockito.when((Object)this.conn.receiveRequestHeader()).thenReturn((Object)request);
        Mockito.when((Object)this.responseFactory.newHttpResponse(200)).thenReturn((Object)this.response);
        Mockito.when((Object)this.handlerResolver.resolve((HttpRequest)request, (HttpContext)context)).thenReturn((Object)this.requestHandler);
        ((HttpRequestHandler)Mockito.doThrow((Throwable[])new Throwable[]{new UnsupportedHttpVersionException()}).when((Object)this.requestHandler)).handle((ClassicHttpRequest)request, this.response, (HttpContext)context);
        this.httpservice.handleRequest(this.conn, (HttpContext)context);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(ClassicHttpResponse.class);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseHeader((ClassicHttpResponse)responseCaptor.capture());
        ClassicHttpResponse error = (ClassicHttpResponse)responseCaptor.getValue();
        Assertions.assertNotNull((Object)error);
        Assertions.assertSame((Object)request, (Object)context.getRequest());
        Assertions.assertEquals((int)505, (int)error.getCode());
        ((HttpProcessor)Mockito.verify((Object)this.httprocessor)).process((HttpResponse)error, (EntityDetails)error.getEntity(), (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseHeader(error);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseEntity(error);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).close();
    }

    @Test
    void testProtocolException() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("whatever", "/");
        Mockito.when((Object)this.conn.receiveRequestHeader()).thenReturn((Object)request);
        Mockito.when((Object)this.responseFactory.newHttpResponse(200)).thenReturn((Object)this.response);
        Mockito.when((Object)this.handlerResolver.resolve((HttpRequest)request, (HttpContext)context)).thenReturn((Object)this.requestHandler);
        ((HttpRequestHandler)Mockito.doThrow((Throwable[])new Throwable[]{new ProtocolException("oh, this world is wrong")}).when((Object)this.requestHandler)).handle((ClassicHttpRequest)request, this.response, (HttpContext)context);
        this.httpservice.handleRequest(this.conn, (HttpContext)context);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(ClassicHttpResponse.class);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseHeader((ClassicHttpResponse)responseCaptor.capture());
        ClassicHttpResponse error = (ClassicHttpResponse)responseCaptor.getValue();
        Assertions.assertNotNull((Object)error);
        Assertions.assertSame((Object)request, (Object)context.getRequest());
        Assertions.assertEquals((int)400, (int)error.getCode());
        ((HttpProcessor)Mockito.verify((Object)this.httprocessor)).process((HttpResponse)error, (EntityDetails)error.getEntity(), (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseHeader(error);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseEntity(error);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).close();
    }

    @Test
    void testConnectionKeepAlive() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        Mockito.when((Object)this.conn.receiveRequestHeader()).thenReturn((Object)request);
        Mockito.when((Object)this.responseFactory.newHttpResponse(200)).thenReturn((Object)this.response);
        Mockito.when((Object)this.handlerResolver.resolve((HttpRequest)request, (HttpContext)context)).thenReturn((Object)this.requestHandler);
        Mockito.when((Object)this.connReuseStrategy.keepAlive((HttpRequest)request, (HttpResponse)this.response, (HttpContext)context)).thenReturn((Object)Boolean.TRUE);
        this.httpservice.handleRequest(this.conn, (HttpContext)context);
        Assertions.assertEquals((int)200, (int)this.response.getCode());
        Assertions.assertSame((Object)request, (Object)context.getRequest());
        Assertions.assertSame((Object)this.response, (Object)context.getResponse());
        ((HttpProcessor)Mockito.verify((Object)this.httprocessor)).process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)this.httprocessor)).process((HttpResponse)this.response, (EntityDetails)this.response.getEntity(), (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseHeader(this.response);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseEntity(this.response);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).flush();
        ((HttpServerConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.never())).close();
        ((ClassicHttpResponse)Mockito.verify((Object)this.response)).close();
    }

    @Test
    void testNoContentResponse() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        Mockito.when((Object)this.conn.receiveRequestHeader()).thenReturn((Object)request);
        Mockito.when((Object)this.responseFactory.newHttpResponse(200)).thenReturn((Object)this.response);
        Mockito.when((Object)this.handlerResolver.resolve((HttpRequest)request, (HttpContext)context)).thenReturn((request1, response, context1) -> response.setCode(204));
        Mockito.when((Object)this.connReuseStrategy.keepAlive((HttpRequest)request, (HttpResponse)this.response, (HttpContext)context)).thenReturn((Object)Boolean.TRUE);
        this.httpservice.handleRequest(this.conn, (HttpContext)context);
        Assertions.assertSame((Object)request, (Object)context.getRequest());
        ((HttpProcessor)Mockito.verify((Object)this.httprocessor)).process((HttpResponse)this.response, (EntityDetails)this.response.getEntity(), (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseHeader(this.response);
        ((HttpServerConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.never())).sendResponseEntity((ClassicHttpResponse)ArgumentMatchers.any());
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).flush();
        ((HttpServerConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.never())).close();
        ((ClassicHttpResponse)Mockito.verify((Object)this.response)).close();
    }

    @Test
    void testResponseToHead() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.HEAD, "/");
        Mockito.when((Object)this.conn.receiveRequestHeader()).thenReturn((Object)request);
        Mockito.when((Object)this.responseFactory.newHttpResponse(200)).thenReturn((Object)this.response);
        Mockito.when((Object)this.handlerResolver.resolve((HttpRequest)request, (HttpContext)context)).thenReturn((Object)this.requestHandler);
        Mockito.when((Object)this.connReuseStrategy.keepAlive((HttpRequest)request, (HttpResponse)this.response, (HttpContext)context)).thenReturn((Object)Boolean.TRUE);
        this.httpservice.handleRequest(this.conn, (HttpContext)context);
        Assertions.assertSame((Object)request, (Object)context.getRequest());
        ((HttpProcessor)Mockito.verify((Object)this.httprocessor)).process((HttpResponse)this.response, (EntityDetails)this.response.getEntity(), (HttpContext)context);
        ((HttpRequestHandler)Mockito.verify((Object)this.requestHandler)).handle((ClassicHttpRequest)request, this.response, (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).sendResponseHeader(this.response);
        ((HttpServerConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.never())).sendResponseEntity((ClassicHttpResponse)ArgumentMatchers.any());
        ((HttpServerConnection)Mockito.verify((Object)this.conn)).flush();
        ((HttpServerConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.never())).close();
        ((ClassicHttpResponse)Mockito.verify((Object)this.response)).close();
    }
}

