/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.ssl;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.hc.core5.ssl.SSLContexts;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

class SSLContextsTest {
    SSLContextsTest() {
    }

    @Test
    void createDefault() {
        SSLContext sslContext = SSLContexts.createDefault();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)sslContext), () -> Assertions.assertEquals((Object)"TLS", (Object)sslContext.getProtocol()), () -> Assertions.assertNotNull((Object)sslContext.getProvider())});
    }

    @Test
    void createSystemDefault() {
        SSLContext sslContext = SSLContexts.createSystemDefault();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)sslContext), () -> Assertions.assertEquals((Object)"Default", (Object)sslContext.getProtocol()), () -> Assertions.assertNotNull((Object)sslContext.getProvider())});
    }

    @Test
    void custom() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        SSLContext sslContext = SSLContexts.custom().setKeyStoreType(KeyStore.getDefaultType()).setKeyManagerFactoryAlgorithm(KeyManagerFactory.getDefaultAlgorithm()).setTrustManagerFactoryAlgorithm(TrustManagerFactory.getDefaultAlgorithm()).setProvider("SunJSSE").setProtocol("TLS").setSecureRandom(null).loadTrustMaterial((KeyStore)null, null).loadKeyMaterial((KeyStore)null, null, null).build();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)sslContext), () -> Assertions.assertEquals((Object)"TLS", (Object)sslContext.getProtocol()), () -> Assertions.assertEquals((Object)"SunJSSE", (Object)sslContext.getProvider().getName())});
    }
}

