/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.net;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.apache.hc.core5.net.PercentCodec;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class TestPercentCodec {
    TestPercentCodec() {
    }

    @Test
    void testCoding() {
        StringBuilder buf = new StringBuilder();
        PercentCodec.encode((StringBuilder)buf, (CharSequence)"blah!", (Charset)StandardCharsets.UTF_8);
        PercentCodec.encode((StringBuilder)buf, (CharSequence)" ~ ", (Charset)StandardCharsets.UTF_8);
        PercentCodec.encode((StringBuilder)buf, (CharSequence)"huh?", (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.equalTo((Object)"blah%21%20~%20huh%3F"));
    }

    @Test
    void testDecoding() {
        MatcherAssert.assertThat((Object)PercentCodec.decode((CharSequence)"blah%21%20~%20huh%3F", (Charset)StandardCharsets.UTF_8), (Matcher)CoreMatchers.equalTo((Object)"blah! ~ huh?"));
        MatcherAssert.assertThat((Object)PercentCodec.decode((CharSequence)"blah%21+~%20huh%3F", (Charset)StandardCharsets.UTF_8), (Matcher)CoreMatchers.equalTo((Object)"blah!+~ huh?"));
        MatcherAssert.assertThat((Object)PercentCodec.decode((CharSequence)"blah%21+~%20huh%3F", (Charset)StandardCharsets.UTF_8, (boolean)true), (Matcher)CoreMatchers.equalTo((Object)"blah! ~ huh?"));
    }

    @Test
    void testDecodingPartialContent() {
        MatcherAssert.assertThat((Object)PercentCodec.decode((CharSequence)"blah%21%20%", (Charset)StandardCharsets.UTF_8), (Matcher)CoreMatchers.equalTo((Object)"blah! %"));
        MatcherAssert.assertThat((Object)PercentCodec.decode((CharSequence)"blah%21%20%a", (Charset)StandardCharsets.UTF_8), (Matcher)CoreMatchers.equalTo((Object)"blah! %a"));
        MatcherAssert.assertThat((Object)PercentCodec.decode((CharSequence)"blah%21%20%wa", (Charset)StandardCharsets.UTF_8), (Matcher)CoreMatchers.equalTo((Object)"blah! %wa"));
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void testRfc5987EncodingDecoding(String input, String expected) {
        Assertions.assertEquals((Object)expected, (Object)PercentCodec.RFC5987.encode((CharSequence)input));
        Assertions.assertEquals((Object)input, (Object)PercentCodec.RFC5987.decode((CharSequence)expected));
    }

    static Stream<Object[]> params() {
        return Stream.of({"foo-\u00e4-\u20ac.html", "foo-%C3%A4-%E2%82%AC.html"}, {"\u4e16\u754c\u30fc\u30d5\u30a1\u30a4\u30eb 2.jpg", "%E4%B8%96%E7%95%8C%E3%83%BC%E3%83%95%E3%82%A1%E3%82%A4%E3%83%AB%202.jpg"}, {"foo.jpg", "foo.jpg"}, {"simple", "simple"}, {"reserved/chars?", "reserved%2Fchars%3F"}, {"", ""}, {"space test", "space%20test"}, {"\u00fcmlaut", "%C3%BCmlaut"});
    }

    @Test
    void verifyRfc5987EncodingandDecoding() {
        String s = "!\"$\u00a3%^&*()_-+={[}]:@~;'#,./<>?\\|\u2713\u00e9\u00e8\u00e6\u00f0\u0143\u0153";
        MatcherAssert.assertThat((Object)PercentCodec.RFC5987.decode((CharSequence)PercentCodec.RFC5987.encode((CharSequence)"!\"$\u00a3%^&*()_-+={[}]:@~;'#,./<>?\\|\u2713\u00e9\u00e8\u00e6\u00f0\u0143\u0153")), (Matcher)CoreMatchers.equalTo((Object)"!\"$\u00a3%^&*()_-+={[}]:@~;'#,./<>?\\|\u2713\u00e9\u00e8\u00e6\u00f0\u0143\u0153"));
    }
}

