/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import org.apache.ignite.internal.sql.engine.message.QueryBatchAcknowledgeMessage;
import org.apache.ignite.internal.sql.engine.message.QueryBatchAcknowledgeMessageBuilder;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesFactory;
import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;

class QueryBatchAcknowledgeMessageDeserializer
implements MessageDeserializer<QueryBatchAcknowledgeMessage> {
    private final QueryBatchAcknowledgeMessageBuilder msg;

    QueryBatchAcknowledgeMessageDeserializer(SqlQueryMessagesFactory messageFactory) {
        this.msg = messageFactory.queryBatchAcknowledgeMessage();
    }

    public Class<QueryBatchAcknowledgeMessage> klass() {
        return QueryBatchAcknowledgeMessage.class;
    }

    public QueryBatchAcknowledgeMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.batchId(reader.readInt("batchId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.exchangeId(reader.readLong("exchangeId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.fragmentId(reader.readLong("fragmentId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.msg.queryId(reader.readUuid("queryId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(QueryBatchAcknowledgeMessage.class);
    }
}

