/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.sql.engine.message.QueryStartRequest;
import org.apache.ignite.internal.sql.engine.message.QueryStartRequestBuilder;
import org.apache.ignite.internal.sql.engine.metadata.FragmentDescription;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class QueryStartRequestImpl
implements QueryStartRequest {
    public static final short GROUP_TYPE = 4;
    public static final short TYPE = 0;
    @IgniteToStringInclude
    private FragmentDescription fragmentDescription;
    private byte[] fragmentDescriptionByteArray;
    @IgniteToStringInclude
    private final long fragmentId;
    @IgniteToStringInclude
    private Object[] parameters;
    private byte[] parametersByteArray;
    @IgniteToStringInclude
    private final UUID queryId;
    @IgniteToStringInclude
    private final String root;
    @IgniteToStringInclude
    private final String schema;
    @IgniteToStringInclude
    private HybridTimestamp txTime;
    private byte[] txTimeByteArray;

    private QueryStartRequestImpl(FragmentDescription fragmentDescription, byte[] fragmentDescriptionByteArray, long fragmentId, Object[] parameters, byte[] parametersByteArray, UUID queryId, String root, String schema, HybridTimestamp txTime, byte[] txTimeByteArray) {
        this.fragmentDescription = fragmentDescription;
        this.fragmentDescriptionByteArray = fragmentDescriptionByteArray;
        this.fragmentId = fragmentId;
        this.parameters = parameters;
        this.parametersByteArray = parametersByteArray;
        this.queryId = queryId;
        this.root = root;
        this.schema = schema;
        this.txTime = txTime;
        this.txTimeByteArray = txTimeByteArray;
    }

    byte[] fragmentDescriptionByteArray() {
        return this.fragmentDescriptionByteArray;
    }

    @Override
    public FragmentDescription fragmentDescription() {
        return this.fragmentDescription;
    }

    @Override
    public long fragmentId() {
        return this.fragmentId;
    }

    byte[] parametersByteArray() {
        return this.parametersByteArray;
    }

    @Override
    public Object[] parameters() {
        return this.parameters;
    }

    @Override
    public UUID queryId() {
        return this.queryId;
    }

    @Override
    public String root() {
        return this.root;
    }

    @Override
    public String schema() {
        return this.schema;
    }

    byte[] txTimeByteArray() {
        return this.txTimeByteArray;
    }

    @Override
    public HybridTimestamp txTime() {
        return this.txTime;
    }

    public short groupType() {
        return 4;
    }

    public String toString() {
        return S.toString(QueryStartRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        QueryStartRequestImpl otherMessage = (QueryStartRequestImpl)other;
        return Objects.equals(this.fragmentDescription, otherMessage.fragmentDescription) && Objects.equals(this.queryId, otherMessage.queryId) && Objects.equals(this.root, otherMessage.root) && Objects.equals(this.schema, otherMessage.schema) && Objects.equals(this.txTime, otherMessage.txTime) && Arrays.equals(this.parameters, otherMessage.parameters) && this.fragmentId == otherMessage.fragmentId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.fragmentId, this.fragmentDescription, this.queryId, this.root, this.schema, this.txTime);
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public static QueryStartRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject fragmentDescriptionByteArraymo = marshaller.marshal((Object)this.fragmentDescription);
        usedDescriptors.addAll((IntCollection)fragmentDescriptionByteArraymo.usedDescriptorIds());
        this.fragmentDescriptionByteArray = fragmentDescriptionByteArraymo.bytes();
        MarshalledObject parametersByteArraymo = marshaller.marshal((Object)this.parameters);
        usedDescriptors.addAll((IntCollection)parametersByteArraymo.usedDescriptorIds());
        this.parametersByteArray = parametersByteArraymo.bytes();
        MarshalledObject txTimeByteArraymo = marshaller.marshal((Object)this.txTime);
        usedDescriptors.addAll((IntCollection)txTimeByteArraymo.usedDescriptorIds());
        this.txTimeByteArray = txTimeByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.fragmentDescription = (FragmentDescription)marshaller.unmarshal(this.fragmentDescriptionByteArray, descriptorsObj);
        this.fragmentDescriptionByteArray = null;
        this.parameters = (Object[])marshaller.unmarshal(this.parametersByteArray, descriptorsObj);
        this.parametersByteArray = null;
        this.txTime = (HybridTimestamp)marshaller.unmarshal(this.txTimeByteArray, descriptorsObj);
        this.txTimeByteArray = null;
    }

    private static class Builder
    implements QueryStartRequestBuilder {
        private FragmentDescription fragmentDescription;
        private byte[] fragmentDescriptionByteArray;
        private long fragmentId;
        private Object[] parameters;
        private byte[] parametersByteArray;
        private UUID queryId;
        private String root;
        private String schema;
        private HybridTimestamp txTime;
        private byte[] txTimeByteArray;

        private Builder() {
        }

        @Override
        public QueryStartRequestBuilder fragmentDescription(FragmentDescription fragmentDescription) {
            this.fragmentDescription = fragmentDescription;
            return this;
        }

        @Override
        public QueryStartRequestBuilder fragmentDescriptionByteArray(byte[] fragmentDescriptionByteArray) {
            this.fragmentDescriptionByteArray = fragmentDescriptionByteArray;
            return this;
        }

        @Override
        public QueryStartRequestBuilder fragmentId(long fragmentId) {
            this.fragmentId = fragmentId;
            return this;
        }

        @Override
        public QueryStartRequestBuilder parameters(Object[] parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public QueryStartRequestBuilder parametersByteArray(byte[] parametersByteArray) {
            this.parametersByteArray = parametersByteArray;
            return this;
        }

        @Override
        public QueryStartRequestBuilder queryId(UUID queryId) {
            this.queryId = queryId;
            return this;
        }

        @Override
        public QueryStartRequestBuilder root(String root) {
            this.root = root;
            return this;
        }

        @Override
        public QueryStartRequestBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public QueryStartRequestBuilder txTime(HybridTimestamp txTime) {
            this.txTime = txTime;
            return this;
        }

        @Override
        public QueryStartRequestBuilder txTimeByteArray(byte[] txTimeByteArray) {
            this.txTimeByteArray = txTimeByteArray;
            return this;
        }

        @Override
        public FragmentDescription fragmentDescription() {
            return this.fragmentDescription;
        }

        @Override
        public byte[] fragmentDescriptionByteArray() {
            return this.fragmentDescriptionByteArray;
        }

        @Override
        public long fragmentId() {
            return this.fragmentId;
        }

        @Override
        public Object[] parameters() {
            return this.parameters;
        }

        @Override
        public byte[] parametersByteArray() {
            return this.parametersByteArray;
        }

        @Override
        public UUID queryId() {
            return this.queryId;
        }

        @Override
        public String root() {
            return this.root;
        }

        @Override
        public String schema() {
            return this.schema;
        }

        @Override
        public HybridTimestamp txTime() {
            return this.txTime;
        }

        @Override
        public byte[] txTimeByteArray() {
            return this.txTimeByteArray;
        }

        @Override
        public QueryStartRequest build() {
            return new QueryStartRequestImpl(this.fragmentDescription, this.fragmentDescriptionByteArray, this.fragmentId, this.parameters, this.parametersByteArray, this.queryId, this.root, this.schema, this.txTime, this.txTimeByteArray);
        }
    }
}

