/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.sql.engine.metadata.ColocationGroup;
import org.apache.ignite.internal.sql.engine.metadata.FragmentMapping;
import org.apache.ignite.internal.sql.engine.metadata.MappingService;
import org.apache.ignite.internal.sql.engine.prepare.ExecutionPlan;
import org.apache.ignite.internal.sql.engine.prepare.Fragment;
import org.apache.ignite.internal.sql.engine.prepare.MappingQueryContext;
import org.apache.ignite.internal.sql.engine.prepare.MultiStepPlan;
import org.apache.ignite.internal.sql.engine.prepare.QueryTemplate;
import org.apache.ignite.internal.sql.engine.rel.IgniteReceiver;
import org.apache.ignite.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.sql.ResultSetMetadata;

public abstract class AbstractMultiStepPlan
implements MultiStepPlan {
    protected final ResultSetMetadata meta;
    protected final QueryTemplate queryTemplate;
    protected ExecutionPlan executionPlan;

    protected AbstractMultiStepPlan(QueryTemplate queryTemplate, ResultSetMetadata meta) {
        this.queryTemplate = queryTemplate;
        this.meta = meta;
    }

    @Override
    public List<Fragment> fragments() {
        return Objects.requireNonNull(this.executionPlan).fragments();
    }

    @Override
    public ResultSetMetadata metadata() {
        return this.meta;
    }

    @Override
    public FragmentMapping mapping(Fragment fragment) {
        return this.mapping(fragment.fragmentId());
    }

    private FragmentMapping mapping(long fragmentId) {
        return Objects.requireNonNull(this.executionPlan).fragments().stream().filter(f -> f.fragmentId() == fragmentId).findAny().orElseThrow(() -> new IllegalStateException("Cannot find fragment with given ID. [fragmentId=" + fragmentId + ", fragments=" + this.fragments() + "]")).mapping();
    }

    @Override
    public ColocationGroup target(Fragment fragment) {
        if (fragment.rootFragment()) {
            return null;
        }
        IgniteSender sender = (IgniteSender)fragment.root();
        return this.mapping(sender.targetFragmentId()).findGroup(sender.exchangeId());
    }

    @Override
    public Long2ObjectOpenHashMap<List<String>> remotes(Fragment fragment) {
        List<IgniteReceiver> remotes = fragment.remotes();
        if (CollectionUtils.nullOrEmpty(remotes)) {
            return null;
        }
        Long2ObjectOpenHashMap res = new Long2ObjectOpenHashMap(IgniteUtils.capacity((int)remotes.size()));
        for (IgniteReceiver remote : remotes) {
            res.put(remote.exchangeId(), this.mapping(remote.sourceFragmentId()).nodeIds());
        }
        return res;
    }

    @Override
    public void init(MappingService mappingService, MappingQueryContext ctx) {
        this.executionPlan = this.queryTemplate.map(mappingService, ctx);
    }
}

