/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.rocksdb.RocksDB;

class ColumnFamilyUtils {
    static final String META_CF_NAME = new String(RocksDB.DEFAULT_COLUMN_FAMILY, StandardCharsets.UTF_8);
    static final String PARTITION_CF_NAME = "cf-part";
    static final String HASH_INDEX_CF_NAME = "cf-hash";
    static final String SORTED_INDEX_CF_PREFIX = "cf-sorted-";

    ColumnFamilyUtils() {
    }

    static String sortedIndexCfName(UUID indexId) {
        return SORTED_INDEX_CF_PREFIX + indexId;
    }

    static UUID sortedIndexId(String cfName) {
        return UUID.fromString(cfName.substring(SORTED_INDEX_CF_PREFIX.length()));
    }

    static enum ColumnFamilyType {
        META,
        PARTITION,
        HASH_INDEX,
        SORTED_INDEX,
        UNKNOWN;


        static ColumnFamilyType fromCfName(String cfName) {
            if (META_CF_NAME.equals(cfName)) {
                return META;
            }
            if (ColumnFamilyUtils.PARTITION_CF_NAME.equals(cfName)) {
                return PARTITION;
            }
            if (ColumnFamilyUtils.HASH_INDEX_CF_NAME.equals(cfName)) {
                return HASH_INDEX;
            }
            if (cfName.startsWith(ColumnFamilyUtils.SORTED_INDEX_CF_PREFIX)) {
                return SORTED_INDEX;
            }
            return UNKNOWN;
        }
    }
}

