/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.fdetector;

import java.util.StringJoiner;
import reactor.core.Exceptions;

public final class FailureDetectorConfig
implements Cloneable {
    public static final int DEFAULT_PING_INTERVAL = 1000;
    public static final int DEFAULT_PING_TIMEOUT = 500;
    public static final int DEFAULT_PING_REQ_MEMBERS = 3;
    public static final int DEFAULT_WAN_PING_TIMEOUT = 3000;
    public static final int DEFAULT_WAN_PING_INTERVAL = 5000;
    public static final int DEFAULT_LOCAL_PING_TIMEOUT = 200;
    public static final int DEFAULT_LOCAL_PING_INTERVAL = 1000;
    public static final int DEFAULT_LOCAL_PING_REQ_MEMBERS = 1;
    private int pingInterval = 1000;
    private int pingTimeout = 500;
    private int pingReqMembers = 3;

    public static FailureDetectorConfig defaultConfig() {
        return new FailureDetectorConfig();
    }

    public static FailureDetectorConfig defaultLanConfig() {
        return FailureDetectorConfig.defaultConfig();
    }

    public static FailureDetectorConfig defaultWanConfig() {
        return FailureDetectorConfig.defaultConfig().pingTimeout(3000).pingInterval(5000);
    }

    public static FailureDetectorConfig defaultLocalConfig() {
        return FailureDetectorConfig.defaultConfig().pingTimeout(200).pingInterval(1000).pingReqMembers(1);
    }

    public FailureDetectorConfig pingInterval(int pingInterval) {
        FailureDetectorConfig f = this.clone();
        f.pingInterval = pingInterval;
        return f;
    }

    public int pingInterval() {
        return this.pingInterval;
    }

    public FailureDetectorConfig pingTimeout(int pingTimeout) {
        FailureDetectorConfig f = this.clone();
        f.pingTimeout = pingTimeout;
        return f;
    }

    public int pingTimeout() {
        return this.pingTimeout;
    }

    public FailureDetectorConfig pingReqMembers(int pingReqMembers) {
        FailureDetectorConfig f = this.clone();
        f.pingReqMembers = pingReqMembers;
        return f;
    }

    public int pingReqMembers() {
        return this.pingReqMembers;
    }

    public FailureDetectorConfig clone() {
        try {
            return (FailureDetectorConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public String toString() {
        return new StringJoiner(", ", FailureDetectorConfig.class.getSimpleName() + "[", "]").add("pingInterval=" + this.pingInterval).add("pingTimeout=" + this.pingTimeout).add("pingReqMembers=" + this.pingReqMembers).toString();
    }
}

