/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rocksdb;

import org.apache.ignite.internal.rocksdb.RocksBiConsumer;
import org.apache.ignite.internal.rocksdb.RocksBiPredicate;
import org.apache.ignite.lang.IgniteInternalException;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public class RocksUtils {
    public static void forEach(RocksIterator iterator, RocksBiConsumer consumer) throws RocksDBException {
        while (iterator.isValid()) {
            consumer.accept(iterator.key(), iterator.value());
            iterator.next();
        }
        RocksUtils.checkIterator(iterator);
    }

    public static boolean find(RocksIterator iterator, RocksBiPredicate consumer) throws RocksDBException {
        while (iterator.isValid()) {
            boolean result = consumer.test(iterator.key(), iterator.value());
            if (result) {
                return true;
            }
            iterator.next();
        }
        RocksUtils.checkIterator(iterator);
        return false;
    }

    public static void checkIterator(RocksIterator it) {
        try {
            it.status();
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException((Throwable)e);
        }
    }

    public static byte @Nullable [] incrementArray(byte[] array) {
        int i;
        byte[] result = (byte[])array.clone();
        for (i = array.length - 1; i >= 0 && array[i] == -1; --i) {
            result[i] = 0;
        }
        if (i == -1) {
            return null;
        }
        int n = i;
        result[n] = (byte)(result[n] + 1);
        return result;
    }
}

