/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity;

import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.entity.SnapshotMetaBuilder;

class SnapshotMetaDeserializer
implements MessageDeserializer<RaftOutter.SnapshotMeta> {
    private final SnapshotMetaBuilder msg;

    SnapshotMetaDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.snapshotMeta();
    }

    public Class<RaftOutter.SnapshotMeta> klass() {
        return RaftOutter.SnapshotMeta.class;
    }

    public RaftOutter.SnapshotMeta getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.lastIncludedIndex(reader.readLong("lastIncludedIndex"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.lastIncludedTerm(reader.readLong("lastIncludedTerm"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.learnersList(reader.readCollection("learnersList", MessageCollectionItemType.STRING));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.msg.oldLearnersList(reader.readCollection("oldLearnersList", MessageCollectionItemType.STRING));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.msg.oldPeersList(reader.readCollection("oldPeersList", MessageCollectionItemType.STRING));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.msg.peersList(reader.readCollection("peersList", MessageCollectionItemType.STRING));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RaftOutter.SnapshotMeta.class);
    }
}

