/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binarytuple;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.UUID;
import org.apache.ignite.lang.IgniteInternalException;

public class BinaryTupleCommon {
    public static final int HEADER_SIZE = 1;
    public static final int VARSIZE_MASK = 3;
    public static final int NULLMAP_FLAG = 4;
    public static final int PREFIX_FLAG = 8;
    public static final int EQUALITY_FLAG = 16;
    public static final UUID DEFAULT_UUID = new UUID(0L, 0L);
    public static final LocalDate DEFAULT_DATE = LocalDate.of(0, 1, 1);
    public static final LocalTime DEFAULT_TIME = LocalTime.of(0, 0);
    public static final LocalDateTime DEFAULT_DATE_TIME = LocalDateTime.of(0, 1, 1, 0, 0);
    public static final Instant DEFAULT_TIMESTAMP = Instant.EPOCH;
    public static final Duration DEFAULT_DURATION = Duration.ZERO;
    public static final Period DEFAULT_PERIOD = Period.ZERO;

    public static byte valueSizeToFlags(long size) {
        if (size <= 255L) {
            return 0;
        }
        if (size <= 65535L) {
            return 1;
        }
        if (size <= Integer.MAX_VALUE) {
            return 2;
        }
        throw new IgniteInternalException("Too big binary tuple size");
    }

    public static int flagsToEntrySize(byte flags) {
        return 1 << (flags & 3);
    }

    public static int nullMapSize(int numElements) {
        return (numElements + 7) / 8;
    }

    public static int nullOffset(int index) {
        return 1 + index / 8;
    }

    public static byte nullMask(int index) {
        return (byte)(1 << index % 8);
    }

    public static int valueSizeToEntrySize(long size) {
        if (size <= 255L) {
            return 1;
        }
        if (size <= 65535L) {
            return 2;
        }
        if (size <= Integer.MAX_VALUE) {
            return 4;
        }
        throw new IgniteInternalException("Too big binary tuple size");
    }
}

