/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.ConfigurationTree;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.configuration.validation.ExceptKeys;
import org.apache.ignite.configuration.validation.Immutable;
import org.apache.ignite.configuration.validation.OneOf;
import org.apache.ignite.configuration.validation.PowerOfTwo;
import org.apache.ignite.configuration.validation.Range;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.configuration.ConfigurationChanger;
import org.apache.ignite.internal.configuration.ConfigurationListenerHolder;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.notifications.ConfigurationNotifier;
import org.apache.ignite.internal.configuration.notifications.ConfigurationStorageRevisionListener;
import org.apache.ignite.internal.configuration.notifications.ConfigurationStorageRevisionListenerHolder;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.configuration.util.KeyNotFoundException;
import org.apache.ignite.internal.configuration.validation.ExceptKeysValidator;
import org.apache.ignite.internal.configuration.validation.ImmutableValidator;
import org.apache.ignite.internal.configuration.validation.OneOfValidator;
import org.apache.ignite.internal.configuration.validation.PowerOfTwoValidator;
import org.apache.ignite.internal.configuration.validation.RangeValidator;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class ConfigurationRegistry
implements IgniteComponent,
ConfigurationStorageRevisionListenerHolder {
    private static final IgniteLogger LOG = Loggers.forClass(ConfigurationRegistry.class);
    private final Map<String, DynamicConfiguration<?, ?>> configs = new HashMap();
    private final Collection<RootKey<?, ?>> rootKeys;
    private final ConfigurationChanger changer;
    private final ConfigurationAsmGenerator cgen = new ConfigurationAsmGenerator();
    private final ConfigurationListenerHolder<ConfigurationStorageRevisionListener> storageRevisionListeners = new ConfigurationListenerHolder();

    public ConfigurationRegistry(Collection<RootKey<?, ?>> rootKeys, Map<Class<? extends Annotation>, Set<Validator<? extends Annotation, ?>>> validators, ConfigurationStorage storage, Collection<Class<?>> internalSchemaExtensions, Collection<Class<?>> polymorphicSchemaExtensions) {
        ConfigurationUtil.checkConfigurationType(rootKeys, storage);
        Set<Class<?>> allSchemas = this.collectAllSchemas(rootKeys, internalSchemaExtensions, polymorphicSchemaExtensions);
        Map<Class<?>, Set<Class<?>>> internalExtensions = this.internalExtensionsWithCheck(allSchemas, internalSchemaExtensions);
        Map<Class<?>, Set<Class<?>>> polymorphicExtensions = this.polymorphicExtensionsWithCheck(allSchemas, polymorphicSchemaExtensions);
        this.rootKeys = rootKeys;
        HashMap validators0 = new HashMap(validators);
        ConfigurationRegistry.addDefaultValidator(validators0, Immutable.class, new ImmutableValidator());
        ConfigurationRegistry.addDefaultValidator(validators0, OneOf.class, new OneOfValidator());
        ConfigurationRegistry.addDefaultValidator(validators0, ExceptKeys.class, new ExceptKeysValidator());
        ConfigurationRegistry.addDefaultValidator(validators0, PowerOfTwo.class, new PowerOfTwoValidator());
        ConfigurationRegistry.addDefaultValidator(validators0, Range.class, new RangeValidator());
        this.changer = new ConfigurationChanger(this::notificator, rootKeys, validators0, storage){

            @Override
            public InnerNode createRootNode(RootKey<?, ?> rootKey) {
                return ConfigurationRegistry.this.cgen.instantiateNode(rootKey.schemaClass());
            }
        };
        rootKeys.forEach(rootKey -> {
            this.cgen.compileRootSchema(rootKey.schemaClass(), internalExtensions, polymorphicExtensions);
            DynamicConfiguration<?, ?> cfg = this.cgen.instantiateCfg((RootKey<?, ?>)rootKey, this.changer);
            this.configs.put(rootKey.key(), cfg);
        });
    }

    private Set<Class<?>> collectAllSchemas(Collection<RootKey<?, ?>> rootKeys, Collection<Class<?>> internalSchemaExtensions, Collection<Class<?>> polymorphicSchemaExtensions) {
        HashSet allSchemas = new HashSet();
        allSchemas.addAll(ConfigurationUtil.collectSchemas(CollectionUtils.viewReadOnly(rootKeys, RootKey::schemaClass)));
        allSchemas.addAll(ConfigurationUtil.collectSchemas(internalSchemaExtensions));
        allSchemas.addAll(ConfigurationUtil.collectSchemas(polymorphicSchemaExtensions));
        return allSchemas;
    }

    private static <A extends Annotation> void addDefaultValidator(Map<Class<? extends Annotation>, Set<Validator<?, ?>>> validators, Class<A> annotatopnType, Validator<A, ?> validator) {
        validators.computeIfAbsent(annotatopnType, a -> new HashSet(1)).add(validator);
    }

    public void start() {
        this.changer.start();
    }

    public void stop() throws Exception {
        this.changer.stop();
        this.storageRevisionListeners.clear();
    }

    public void initializeDefaults() {
        this.changer.initializeDefaults();
        for (RootKey<?, ?> rootKey : this.rootKeys) {
            DynamicConfiguration<?, ?> dynCfg = this.configs.get(rootKey.key());
            ConfigurationUtil.touch(dynCfg);
        }
    }

    public <V, C, T extends ConfigurationTree<V, C>> T getConfiguration(RootKey<T, V> rootKey) {
        return (T)this.configs.get(rootKey.key());
    }

    public <T> T represent(List<String> path, ConfigurationVisitor<T> visitor) throws IllegalArgumentException {
        Object node;
        SuperRoot superRoot = this.changer.superRoot();
        try {
            node = ConfigurationUtil.find(path, superRoot, false);
        }
        catch (KeyNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (node instanceof TraversableTreeNode) {
            return ((TraversableTreeNode)node).accept(null, visitor);
        }
        assert (node == null || node instanceof Serializable);
        return visitor.visitLeafNode(null, (Serializable)node);
    }

    public CompletableFuture<Void> change(ConfigurationSource changesSrc) {
        return this.changer.change(changesSrc);
    }

    private CompletableFuture<Void> notificator(final @Nullable SuperRoot oldSuperRoot, SuperRoot newSuperRoot, final long storageRevision, final long notificationNumber) {
        final ArrayList futures = new ArrayList();
        newSuperRoot.traverseChildren(new ConfigurationVisitor<Void>(){

            @Override
            public Void visitInnerNode(String key, InnerNode newRoot) {
                InnerNode oldRoot;
                DynamicConfiguration<?, ?> config = ConfigurationRegistry.this.configs.get(key);
                assert (config != null) : key;
                if (oldSuperRoot != null) {
                    oldRoot = oldSuperRoot.traverseChild(key, ConfigurationUtil.innerNodeVisitor(), true);
                    assert (oldRoot != null) : key;
                } else {
                    oldRoot = null;
                }
                futures.addAll(ConfigurationNotifier.notifyListeners(oldRoot, newRoot, config, storageRevision, notificationNumber));
                return null;
            }
        }, true);
        futures.addAll(this.notifyStorageRevisionListeners(storageRevision, notificationNumber));
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        Function<CompletableFuture, CompletableFuture> mapping = fut -> fut.whenComplete((res, throwable) -> {
            if (throwable != null) {
                LOG.info("Failed to notify configuration listener", throwable);
            }
        });
        CompletableFuture[] resultFutures = (CompletableFuture[])futures.stream().map(mapping).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(resultFutures);
    }

    @Override
    public void listenUpdateStorageRevision(ConfigurationStorageRevisionListener listener) {
        this.storageRevisionListeners.addListener(listener, this.changer.notificationCount());
    }

    @Override
    public void stopListenUpdateStorageRevision(ConfigurationStorageRevisionListener listener) {
        this.storageRevisionListeners.removeListener(listener);
    }

    public CompletableFuture<Void> notifyCurrentConfigurationListeners() {
        return this.changer.notifyCurrentConfigurationListeners();
    }

    private Map<Class<?>, Set<Class<?>>> internalExtensionsWithCheck(Set<Class<?>> allSchemas, Collection<Class<?>> internalSchemaExtensions) {
        if (internalSchemaExtensions.isEmpty()) {
            return Map.of();
        }
        Map<Class<?>, Set<Class<?>>> internalExtensions = ConfigurationUtil.internalSchemaExtensions(internalSchemaExtensions);
        Set notInAllSchemas = CollectionUtils.difference(internalExtensions.keySet(), allSchemas);
        if (!notInAllSchemas.isEmpty()) {
            throw new IllegalArgumentException("Internal extensions for which no parent configuration schemas were found: " + notInAllSchemas);
        }
        return internalExtensions;
    }

    private Map<Class<?>, Set<Class<?>>> polymorphicExtensionsWithCheck(Set<Class<?>> allSchemas, Collection<Class<?>> polymorphicSchemaExtensions) {
        Map<Class<?>, Set<Class<?>>> polymorphicExtensionsByParent = ConfigurationUtil.polymorphicSchemaExtensions(polymorphicSchemaExtensions);
        Set notInAllSchemas = CollectionUtils.difference(polymorphicExtensionsByParent.keySet(), allSchemas);
        if (!notInAllSchemas.isEmpty()) {
            throw new IllegalArgumentException("Polymorphic extensions for which no polymorphic configuration schemas were found: " + notInAllSchemas);
        }
        Collection noPolymorphicExtensionsSchemas = allSchemas.stream().filter(ConfigurationUtil::isPolymorphicConfig).filter(Predicate.not(polymorphicExtensionsByParent::containsKey)).collect(Collectors.toList());
        if (!noPolymorphicExtensionsSchemas.isEmpty()) {
            throw new IllegalArgumentException("Polymorphic configuration schemas for which no extensions were found: " + noPolymorphicExtensionsSchemas);
        }
        this.checkPolymorphicConfigIds(polymorphicExtensionsByParent);
        for (Map.Entry<Class<?>, Set<Class<?>>> e : polymorphicExtensionsByParent.entrySet()) {
            Class<?> schemaClass = e.getKey();
            Field typeIdField = ConfigurationUtil.schemaFields(schemaClass).get(0);
            if (ConfigurationUtil.isPolymorphicId(typeIdField)) continue;
            throw new IllegalArgumentException(String.format("First field in a polymorphic configuration schema must contain @%s: %s", PolymorphicId.class, schemaClass.getName()));
        }
        return polymorphicExtensionsByParent;
    }

    private void checkPolymorphicConfigIds(Map<Class<?>, Set<Class<?>>> polymorphicExtensions) {
        HashMap ids = new HashMap();
        for (Map.Entry<Class<?>, Set<Class<?>>> e : polymorphicExtensions.entrySet()) {
            for (Class<?> schemaClass : e.getValue()) {
                String id = ConfigurationUtil.polymorphicInstanceId(schemaClass);
                Class<?> prev = ids.put(id, schemaClass);
                if (prev == null) continue;
                throw new IllegalArgumentException("Found an id conflict for a polymorphic configuration [id=" + id + ", schemas=" + List.of(prev, schemaClass));
            }
            ids.clear();
        }
    }

    private Collection<CompletableFuture<?>> notifyStorageRevisionListeners(long storageRevision, long notificationNumber) {
        ArrayList futures = null;
        Iterator<ConfigurationStorageRevisionListener> it = this.storageRevisionListeners.listeners(notificationNumber);
        while (it.hasNext()) {
            if (futures == null) {
                futures = new ArrayList();
            }
            ConfigurationStorageRevisionListener listener = it.next();
            try {
                CompletableFuture<?> future = listener.onUpdate(storageRevision);
                assert (future != null);
                if (!future.isCompletedExceptionally() && !future.isCancelled() && future.isDone()) continue;
                futures.add(future);
            }
            catch (Throwable t) {
                futures.add(CompletableFuture.failedFuture(t));
            }
        }
        return futures == null ? List.of() : futures;
    }

    public long notificationCount() {
        return this.changer.notificationCount();
    }
}

