/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.replicator;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.replicator.ReplicaService;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.tx.message.TxStateReplicaRequest;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.network.ClusterNode;

public class PlacementDriver {
    private final Map<ReplicationGroupId, LinkedHashSet<ClusterNode>> primaryReplicaMapping = new ConcurrentHashMap<ReplicationGroupId, LinkedHashSet<ClusterNode>>();
    private final ReplicaService replicaService;

    public PlacementDriver(ReplicaService replicaService) {
        this.replicaService = replicaService;
    }

    public CompletableFuture<TxMeta> sendMetaRequest(ReplicationGroupId replicaGrp, TxStateReplicaRequest request) {
        CompletableFuture<TxMeta> resFut = new CompletableFuture<TxMeta>();
        this.sendAndRetry(resFut, replicaGrp, request);
        return resFut;
    }

    public void updateAssignment(ReplicationGroupId replicaGrpId, Collection<ClusterNode> assignment) {
        this.primaryReplicaMapping.put(replicaGrpId, new LinkedHashSet<ClusterNode>(assignment));
    }

    private void sendAndRetry(CompletableFuture<TxMeta> resFut, ReplicationGroupId replicaGrp, TxStateReplicaRequest request) {
        ClusterNode nodeToSend = (ClusterNode)this.primaryReplicaMapping.get(replicaGrp).iterator().next();
        this.replicaService.invoke(nodeToSend, (ReplicaRequest)request).thenAccept(resp -> {
            assert (resp instanceof IgniteBiTuple) : "Unsupported response type [type=" + resp.getClass().getSimpleName() + "]";
            IgniteBiTuple stateAndLeader = (IgniteBiTuple)resp;
            ClusterNode nextNodeToSend = (ClusterNode)stateAndLeader.get2();
            if (nextNodeToSend == null) {
                resFut.complete((TxMeta)stateAndLeader.get1());
            } else {
                LinkedHashSet<ClusterNode> newAssignment = new LinkedHashSet<ClusterNode>();
                newAssignment.add(nextNodeToSend);
                newAssignment.addAll((Collection)this.primaryReplicaMapping.get(replicaGrp));
                this.primaryReplicaMapping.put(replicaGrp, newAssignment);
                this.sendAndRetry(resFut, replicaGrp, request);
            }
        });
    }
}

