/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Preconditions;
import com.google.uzaygezen.core.BitVector;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class Pow2LengthBitSetRange {
    private final BitVector start;
    private final int level;
    private static final int ANY_INT = -1;

    public Pow2LengthBitSetRange(BitVector start, int level) {
        this(start, level, -1);
        Preconditions.checkArgument((boolean)start.areAllLowestBitsClear(level), (Object)"Lowest level bits must be zero.");
        Preconditions.checkArgument((boolean)(0 <= level & level <= start.size()), (Object)"level must be non-negative");
    }

    private Pow2LengthBitSetRange(BitVector start, int level, int anyInt) {
        assert (anyInt == -1);
        this.start = start;
        this.level = level;
    }

    public BitVector getStart() {
        return this.start;
    }

    public int getLevel() {
        return this.level;
    }

    public static int levelSum(List<Pow2LengthBitSetRange> pow2LengthOrthotope) {
        int levelSum = 0;
        for (Pow2LengthBitSetRange range : pow2LengthOrthotope) {
            levelSum += range.level;
        }
        return levelSum;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public int hashCode() {
        return this.start.hashCode() + 31 * this.level;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Pow2LengthBitSetRange)) {
            return false;
        }
        Pow2LengthBitSetRange other = (Pow2LengthBitSetRange)obj;
        return this.level == other.level && this.start.equals(other.start);
    }

    public Pow2LengthBitSetRange clone() {
        return new Pow2LengthBitSetRange(this.start.clone(), this.level, -1);
    }

    public boolean encloses(Pow2LengthBitSetRange other) {
        boolean result;
        if (this.level > other.level) {
            this.start.xor(other.start);
            result = this.level == this.start.size() || this.start.nextSetBit(this.level) == -1;
            this.start.xor(other.start);
        } else {
            result = this.level == other.level ? this.start.equals(other.start) : false;
        }
        return result;
    }
}

