/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import org.apache.calcite.adapter.enumerable.EnumerableCalc;
import org.apache.calcite.adapter.enumerable.EnumerableFilter;
import org.apache.calcite.adapter.enumerable.ImmutableEnumerableFilterToCalcRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Value;

@Value.Enclosing
public class EnumerableFilterToCalcRule
extends RelRule<Config> {
    protected EnumerableFilterToCalcRule(Config config) {
        super(config);
    }

    @Deprecated
    public EnumerableFilterToCalcRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        EnumerableFilter filter = (EnumerableFilter)call.rel(0);
        RelNode input = filter.getInput();
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RelDataType inputRowType = input.getRowType();
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, rexBuilder);
        programBuilder.addIdentity();
        programBuilder.addCondition(filter.getCondition());
        RexProgram program = programBuilder.getProgram();
        EnumerableCalc calc = EnumerableCalc.create(input, program);
        call.transformTo(calc);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableEnumerableFilterToCalcRule.Config.of().withOperandSupplier(b -> b.operand(EnumerableFilter.class).anyInputs());

        @Override
        default public EnumerableFilterToCalcRule toRule() {
            return new EnumerableFilterToCalcRule(this);
        }
    }
}

