/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.rules.ImmutableSpatialRules;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.runtime.HilbertCurve2D;
import org.apache.calcite.runtime.SpaceFillingCurve2D;
import org.apache.calcite.runtime.SpatialTypeFunctions;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

@Value.Enclosing
public abstract class SpatialRules {
    private static final RexUtil.RexFinder DWITHIN_FINDER = RexUtil.find(EnumSet.of(SqlKind.ST_DWITHIN, SqlKind.ST_CONTAINS));
    private static final RexUtil.RexFinder HILBERT_FINDER = RexUtil.find(SqlKind.HILBERT);
    public static final RelOptRule INSTANCE = FilterHilbertRule.Config.DEFAULT.toRule();

    private SpatialRules() {
    }

    private static @Nullable Geometry constantGeom(RexNode e) {
        switch (e.getKind()) {
            case CAST: {
                return SpatialRules.constantGeom(((RexCall)e).getOperands().get(0));
            }
            case LITERAL: {
                return (Geometry)((RexLiteral)e).getValue();
            }
        }
        return null;
    }

    public static class FilterHilbertRule
    extends RelRule<Config> {
        protected FilterHilbertRule(Config config) {
            super(config);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            ArrayList<RexNode> conjunctions = new ArrayList<RexNode>();
            RelOptUtil.decomposeConjunction(filter.getCondition(), conjunctions);
            RelOptPredicateList predicates = call.getMetadataQuery().getAllPredicates(filter.getInput());
            if (predicates == null) {
                return;
            }
            int changeCount = 0;
            for (RexNode predicate : predicates.pulledUpPredicates) {
                RelBuilder builder = call.builder();
                if (predicate.getKind() == SqlKind.EQUALS) {
                    RexCall eqCall = (RexCall)predicate;
                    if (eqCall.operands.get(0) instanceof RexInputRef && ((RexNode)eqCall.operands.get(1)).getKind() == SqlKind.HILBERT) {
                        RexInputRef ref = (RexInputRef)eqCall.operands.get(0);
                        RexCall hilbert = (RexCall)eqCall.operands.get(1);
                        RexUtil.RexFinder finder = RexUtil.find(ref);
                        if (finder.anyContain(conjunctions)) continue;
                        int i = 0;
                        while (i < conjunctions.size()) {
                            List<RexNode> replacements = FilterHilbertRule.replaceSpatial((RexNode)conjunctions.get(i), builder, ref, hilbert);
                            if (replacements != null) {
                                conjunctions.remove(i);
                                conjunctions.addAll(i, replacements);
                                i += replacements.size();
                                ++changeCount;
                                continue;
                            }
                            ++i;
                        }
                    }
                }
                if (changeCount <= 0) continue;
                call.transformTo(builder.push(filter.getInput()).filter(conjunctions).build());
                return;
            }
        }

        static @Nullable List<RexNode> replaceSpatial(RexNode conjunction, RelBuilder builder, RexInputRef ref, RexCall hilbert) {
            switch (conjunction.getKind()) {
                case ST_DWITHIN: {
                    RexCall within = (RexCall)conjunction;
                    RexNode op0 = (RexNode)within.operands.get(0);
                    Geometry g0 = SpatialRules.constantGeom(op0);
                    RexNode op1 = (RexNode)within.operands.get(1);
                    Geometry g1 = SpatialRules.constantGeom(op1);
                    if (RexUtil.isLiteral((RexNode)within.operands.get(2), true)) {
                        Number distance = Objects.requireNonNull((Number)((Object)RexLiteral.value((RexNode)within.operands.get(2))), () -> "distance for " + within);
                        switch (Double.compare(distance.doubleValue(), 0.0)) {
                            case -1: {
                                return ImmutableList.of((Object)builder.getRexBuilder().makeLiteral(false));
                            }
                            case 0: {
                                conjunction = builder.equals(op0, op1);
                            }
                            case 1: {
                                if (g0 != null && op1.getKind() == SqlKind.ST_POINT && ((RexCall)op1).operands.equals(hilbert.operands)) {
                                    return ImmutableList.of((Object)FilterHilbertRule.hilbertPredicate(builder.getRexBuilder(), ref, g0, distance), (Object)conjunction);
                                }
                                if (g1 != null && op0.getKind() == SqlKind.ST_POINT && ((RexCall)op0).operands.equals(hilbert.operands)) {
                                    return ImmutableList.of((Object)FilterHilbertRule.hilbertPredicate(builder.getRexBuilder(), ref, g1, distance), (Object)conjunction);
                                }
                                return null;
                            }
                        }
                        throw new AssertionError((Object)("invalid sign: " + distance));
                    }
                    return null;
                }
                case ST_CONTAINS: {
                    RexCall contains = (RexCall)conjunction;
                    RexNode op0 = (RexNode)contains.operands.get(0);
                    Geometry g0 = SpatialRules.constantGeom(op0);
                    RexNode op1 = (RexNode)contains.operands.get(1);
                    if (g0 != null && op1.getKind() == SqlKind.ST_POINT && ((RexCall)op1).operands.equals(hilbert.operands)) {
                        return ImmutableList.of((Object)FilterHilbertRule.hilbertPredicate(builder.getRexBuilder(), ref, g0), (Object)conjunction);
                    }
                    return null;
                }
            }
            return null;
        }

        private static RexNode hilbertPredicate(RexBuilder rexBuilder, RexInputRef ref, Geometry g, Number distance) {
            if (distance.doubleValue() == 0.0 && g instanceof Point) {
                Point p = (Point)g;
                HilbertCurve2D hilbert = new HilbertCurve2D(8);
                long index = hilbert.toIndex(p.getX(), p.getY());
                return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, ref, rexBuilder.makeExactLiteral(BigDecimal.valueOf(index)));
            }
            Geometry g2 = SpatialTypeFunctions.ST_Buffer(g, distance.doubleValue());
            return FilterHilbertRule.hilbertPredicate(rexBuilder, ref, g2);
        }

        private static RexNode hilbertPredicate(RexBuilder rexBuilder, RexInputRef ref, Geometry g2) {
            Geometry g3 = SpatialTypeFunctions.ST_Envelope(g2);
            Envelope env = g3.getEnvelopeInternal();
            HilbertCurve2D hilbert = new HilbertCurve2D(8);
            List<SpaceFillingCurve2D.IndexRange> ranges = hilbert.toRanges(env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY(), new SpaceFillingCurve2D.RangeComputeHints());
            ArrayList<RexNode> nodes = new ArrayList<RexNode>();
            for (SpaceFillingCurve2D.IndexRange range : ranges) {
                BigDecimal lowerBd = BigDecimal.valueOf(range.lower());
                BigDecimal upperBd = BigDecimal.valueOf(range.upper());
                nodes.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, ref, rexBuilder.makeExactLiteral(lowerBd)), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, ref, rexBuilder.makeExactLiteral(upperBd))));
            }
            return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, nodes);
        }

        @Value.Immutable
        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = ImmutableSpatialRules.Config.of().withOperandSupplier(b -> b.operand(Filter.class).predicate(f -> DWITHIN_FINDER.inFilter((Filter)f) && !HILBERT_FINDER.inFilter((Filter)f)).anyInputs()).as(Config.class);

            @Override
            default public FilterHilbertRule toRule() {
                return new FilterHilbertRule(this);
            }
        }
    }
}

