/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.io;

import java.nio.ByteBuffer;
import java.util.ServiceLoader;
import org.apache.ignite.internal.pagememory.io.IoVersions;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.io.PageIoModule;
import org.apache.ignite.lang.IgniteInternalCheckedException;

public class PageIoRegistry {
    protected final IoVersions<?>[] ioVersions = new IoVersions[65535];

    public void loadFromServiceLoader() {
        ServiceLoader<PageIoModule> serviceLoader = ServiceLoader.load(PageIoModule.class);
        for (PageIoModule pageIoModule : serviceLoader) {
            for (IoVersions<?> ios : pageIoModule.ioVersions()) {
                if (ios.getType() == 0) {
                    throw new IllegalStateException("Type 0 is reserved and can't be used: " + ios);
                }
                if (this.ioVersions[ios.getType()] != null && !this.ioVersions[ios.getType()].equals(ios)) {
                    throw new IllegalStateException("Duplicated IOVersions found: " + ios);
                }
                this.ioVersions[ios.getType()] = ios;
            }
        }
    }

    public <V extends PageIo> V resolve(ByteBuffer pageBuf) throws IgniteInternalCheckedException {
        return this.resolve(PageIo.getType(pageBuf), PageIo.getVersion(pageBuf));
    }

    public final <V extends PageIo> V resolve(long pageAddr) throws IgniteInternalCheckedException {
        return this.resolve(PageIo.getType(pageAddr), PageIo.getVersion(pageAddr));
    }

    public <V extends PageIo> V resolve(int type, int ver) throws IgniteInternalCheckedException {
        if (type <= 0 || type > 65534) {
            throw new IgniteInternalCheckedException("Unknown page IO type: " + type);
        }
        IoVersions<?> ios = this.ioVersions[type];
        if (ios == null) {
            throw new IgniteInternalCheckedException("Unknown page IO type: " + type);
        }
        return (V)ios.forVersion(ver);
    }
}

