/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.thread;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.internal.thread.LogUncaughtExceptionHandler;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.jetbrains.annotations.TestOnly;

public class IgniteThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final boolean daemon;
    private final Thread.UncaughtExceptionHandler exHnd;
    private final ThreadOperation[] allowedOperations;

    private IgniteThreadFactory(String nodeName, String poolName, boolean daemon, IgniteLogger log, ThreadOperation[] allowedOperations) {
        this(IgniteThread.threadPrefix(nodeName, poolName), daemon, log, allowedOperations);
    }

    private IgniteThreadFactory(String prefix, boolean daemon, IgniteLogger log, ThreadOperation[] allowedOperations) {
        this.prefix = Objects.requireNonNull(prefix, "prefix");
        this.daemon = daemon;
        this.exHnd = new LogUncaughtExceptionHandler(log);
        this.allowedOperations = allowedOperations;
    }

    @Override
    public Thread newThread(Runnable r) {
        IgniteThread t = new IgniteThread(this.prefix + this.counter.getAndIncrement(), r, this.allowedOperations);
        t.setDaemon(this.daemon);
        t.setUncaughtExceptionHandler(this.exHnd);
        return t;
    }

    public static ThreadFactory create(String nodeName, String poolName, IgniteLogger logger, ThreadOperation ... allowedOperations) {
        return IgniteThreadFactory.create(nodeName, poolName, false, logger, allowedOperations);
    }

    public static ThreadFactory create(String nodeName, String poolName, boolean daemon, IgniteLogger logger, ThreadOperation ... allowedOperations) {
        return new IgniteThreadFactory(nodeName, poolName, daemon, logger, allowedOperations);
    }

    @TestOnly
    public static ThreadFactory withPrefix(String prefix, IgniteLogger logger, ThreadOperation ... allowedOperations) {
        return new IgniteThreadFactory(prefix, false, logger, allowedOperations);
    }
}

